/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.documentActivity.service;

import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.spring.transaction.interceptor.TransactionalHostContextAccessor;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.comalatech.confluence.documentActivity.ao.ActivityDeleteCriteria;
import com.comalatech.confluence.documentActivity.ao.ActivityDetailsDeleteCriteria;
import com.comalatech.confluence.documentActivity.ao.ActivitySearchCriteria;
import com.comalatech.confluence.documentActivity.ao.accesor.ActivityDetailsRecordAccessor;
import com.comalatech.confluence.documentActivity.ao.accesor.ActivityRecordAccessor;
import com.comalatech.confluence.documentActivity.ao.entity.ActivityDetailsRecordEntity;
import com.comalatech.confluence.documentActivity.ao.entity.ActivityRecordEntity;
import com.comalatech.confluence.documentActivity.ao.entity.ActivityRecordOrigin;
import com.comalatech.confluence.documentActivity.ao.entity.BaseActivityDetailsRecord;
import com.comalatech.confluence.documentActivity.ao.entity.BaseActivityRecord;
import com.comalatech.confluence.documentActivity.ao.mapper.ActivityRecordMapper;
import com.comalatech.confluence.documentActivity.domain.entities.Activity;
import com.comalatech.confluence.documentActivity.service.DocumentActivityService;
import com.comalatech.confluence.documentActivity.service.model.DocumentActivityQuery;
import com.comalatech.confluence.documentActivity.service.model.DocumentActivityQueryFilter;
import com.comalatech.confluence.documentActivity.service.model.DocumentActivityResult;
import com.comalatech.confluence.documentActivity.service.model.DocumentActivityResultMetadata;
import com.comalatech.confluence.documentActivity.service.provider.ActivityProvider;
import com.comalatech.confluence.documentActivity.service.provider.ComalaActivityProvider;
import com.comalatech.confluence.documentActivity.service.provider.PageCommentsActivityProvider;
import com.comalatech.confluence.documentActivity.service.provider.PageEditsActivityProvider;
import com.comalatech.confluence.documentActivity.util.ActorUtils;
import com.comalatech.confluence.workflow.user.WorkflowUserAccessor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;

public class DocumentActivityServiceImpl
implements DocumentActivityService {
    private static final Logger log = LoggerFactory.getLogger(DocumentActivityServiceImpl.class);
    @Deprecated
    private static final int EXPORT_ACTIVITY_RESULTS_LIMIT = 10000000;
    private final ActivityRecordAccessor activityRecordAccessor;
    private final ActivityDetailsRecordAccessor activityDetailsRecordAccessor;
    private final ActivityRecordMapper activityRecordMapper;
    private final TransactionalHostContextAccessor transactionalHostContextAccessor;
    private final List<ActivityProvider> activityProviders;
    private final DarkFeatureManager darkFeatureManager;

    public DocumentActivityServiceImpl(ActivityRecordAccessor activityRecordAccessor, ActivityDetailsRecordAccessor activityDetailsRecordAccessor, UserAccessor userAccessor, TransactionalHostContextAccessor transactionalHostContextAccessor, @Qualifier(value="contentEntityManager") ContentEntityManager contentEntityManager, WorkflowUserAccessor workflowUserAccessor, DarkFeatureManager darkFeatureManager) {
        this.activityRecordAccessor = activityRecordAccessor;
        this.activityDetailsRecordAccessor = activityDetailsRecordAccessor;
        this.transactionalHostContextAccessor = transactionalHostContextAccessor;
        this.darkFeatureManager = darkFeatureManager;
        ActorUtils actorUtils = new ActorUtils(userAccessor, workflowUserAccessor);
        this.activityRecordMapper = new ActivityRecordMapper(actorUtils);
        this.activityProviders = Arrays.asList(new PageEditsActivityProvider(contentEntityManager, actorUtils), new PageCommentsActivityProvider(contentEntityManager, actorUtils), new ComalaActivityProvider(activityRecordAccessor, actorUtils));
    }

    @Override
    public void create(Activity activity, ActivityRecordOrigin origin) {
        this.transactionalHostContextAccessor.doInTransaction(TransactionalHostContextAccessor.Propagation.REQUIRES_NEW, TransactionalHostContextAccessor.Permission.READ_WRITE, () -> {
            BaseActivityRecord activityRecord;
            try {
                activityRecord = this.activityRecordMapper.activityToRecord(activity, origin);
            }
            catch (IOException e) {
                log.error("Error mapping the activity.", (Throwable)e);
                return null;
            }
            ActivityRecordEntity activityRecordEntity = this.activityRecordAccessor.create(activityRecord);
            List<BaseActivityDetailsRecord> activityDetailsRecords = this.activityRecordMapper.activityToDetailRecord(activity, activityRecordEntity);
            for (BaseActivityDetailsRecord activityDetailsRecord : activityDetailsRecords) {
                this.activityDetailsRecordAccessor.create(activityDetailsRecord);
            }
            return null;
        });
    }

    @Override
    public void create(Activity activity) {
        this.create(activity, ActivityRecordOrigin.ORIGIN_EVENT);
    }

    @Override
    @Deprecated
    public List<Activity> get(long contentId) throws Exception {
        DocumentActivityQuery query = new DocumentActivityQuery();
        query.setFilters(DocumentActivityQueryFilter.builder().targetId(contentId).build());
        query.setLimit(10000000);
        ArrayList<Activity> activities = new ArrayList<Activity>();
        for (ActivityProvider activityProvider : this.activityProviders) {
            activities.addAll(activityProvider.get(query));
        }
        return activities;
    }

    @Override
    public DocumentActivityResult get(DocumentActivityQuery query) throws Exception {
        if (query == null || query.getFilters() == null) {
            throw new IllegalArgumentException("Invalid query data received. Empty query or empty filters received");
        }
        ArrayList<Activity> activities = new ArrayList<Activity>();
        for (ActivityProvider activityProvider : this.activityProviders) {
            if (this.darkFeatureManager.isFeatureEnabledForAllUsers("comalatech.workflows.show.page.inline-comments")) {
                activities.addAll(activityProvider.get(query));
                continue;
            }
            if (activityProvider instanceof PageCommentsActivityProvider) continue;
            activities.addAll(activityProvider.get(query));
        }
        Comparator sortingComparator = DocumentActivityQuery.SortingOrder.asc == query.getSorting() ? Comparator.naturalOrder() : Comparator.reverseOrder();
        activities.sort(sortingComparator);
        List<Activity> truncatedActivities = activities.subList(0, this.getLimitCheckingUniqueLatestActivity(activities, query));
        boolean hasMoreResults = false;
        Long nextActivityTimestamp = null;
        if (truncatedActivities.size() < activities.size()) {
            hasMoreResults = true;
            nextActivityTimestamp = ((Activity)activities.get(truncatedActivities.size())).getMoment();
        }
        return DocumentActivityResult.builder().activities(truncatedActivities).metadata(DocumentActivityResultMetadata.builder().hasMoreResults(hasMoreResults).resultSize(truncatedActivities.size()).nextActivityTimestamp(nextActivityTimestamp).build()).build();
    }

    private int getLimitCheckingUniqueLatestActivity(List<Activity> activities, DocumentActivityQuery query) {
        if (query.getLimit() == 0) {
            return 0;
        }
        if (activities.size() < query.getLimit()) {
            return activities.size();
        }
        int marker = query.getLimit() - 1;
        long limitTimestamp = activities.get(marker).getMoment();
        while (activities.size() > ++marker && limitTimestamp == activities.get(marker).getMoment()) {
        }
        return marker;
    }

    @Override
    public void delete(Long contentId) {
        this.transactionalHostContextAccessor.doInTransaction(TransactionalHostContextAccessor.Propagation.REQUIRES_NEW, TransactionalHostContextAccessor.Permission.READ_WRITE, () -> {
            ActivitySearchCriteria activitySearchCriteria = new ActivitySearchCriteria();
            activitySearchCriteria.setContentId(contentId);
            List<BaseActivityRecord> activityRecords = this.activityRecordAccessor.search(activitySearchCriteria);
            for (BaseActivityRecord activityRecord : activityRecords) {
                List<ActivityDetailsRecordEntity> activityDetails;
                if (activityRecord.getActivityDetails() == null || (activityDetails = Arrays.asList(activityRecord.getActivityDetails())).isEmpty()) continue;
                ActivityDetailsDeleteCriteria activityDetailsDeleteCriteria = new ActivityDetailsDeleteCriteria();
                activityDetailsDeleteCriteria.setActivityId(activityDetails.get(0).getActivity().getId());
                this.activityDetailsRecordAccessor.delete(activityDetailsDeleteCriteria);
            }
            ActivityDeleteCriteria eventDeleteCriteria = new ActivityDeleteCriteria();
            eventDeleteCriteria.setContentId(contentId);
            this.activityRecordAccessor.delete(eventDeleteCriteria);
            return null;
        });
    }
}

