/*
 * Copyright (c) 2022 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

/**
 * #Editable  (task note)
 */
var AWP = AWP || {};
AWP.View = AWP.View || {};
AWP.View.Editable = Backbone.View.extend({
    // backbone prop
    className: "awp-editable",
    // custom prop
    template : AWP.Templates.editable,

    events: {
        'click .awp-editable-save': 'save',
        'click .awp-editable-close': 'toggle'
    },

    init: function (dataAttr) {
        AJS.$('[data-' + dataAttr + ']').each(_.bind(function(i, item) {
            var $item = AJS.$(item);

            this.createEditBox($item, {
                type: $item.data(dataAttr),
                value: $item.data(dataAttr + '-value')
            });
        }, this));
    },
    
    render: function(content) {
        this.$el.html(this.template(content));
        this.$textarea = this.$('.textarea');
        return this.$el;
    },

    /**
     * Inserts an edit box linked to an editable item
     */
    createEditBox: function ($item, content) {
        // render and insert edit box after the editable item
        $item.after(this.render(content));
        this.$item = $item;

        // by default the edit box is hidden
        this.$el.hide();

        // editable item will be clickable and will show the edit box
        this.$item
            .addClass(this.className + '-item')
            .attr('title', AJS.I18n.getText('adhocworkflows.action.task.edittask.hint'))
            .click(_.bind(function() {
                this.toggle();
                this._focusEnd(this.$textarea);
            }, this));

        // Add edit icon
        var span = AJS.$('<span></span>').addClass('awp-editable-edit aui-icon aui-icon-small aui-iconfont-edit');
        AJS.$('.awp-editable-item').wrap('<div class="awp-editable-container" />');
        AJS.$('.awp-editable-container').append(span);
    },

    /**
     * Update task note
     * TODO should be able to set dynamically what props to be updated, not hardcoded
     */
    save: function () {
        var note = this.$textarea.val();
        this.model.save({
            'note': note
        },{
            action: "update"
        });
        this.$item.html(note);
        this.toggle();
    },

    /**
     * Show/hide the edit box
     */
    toggle: function () {
        this.$el.toggle();
        this.$item.toggle();
    },

    _focusEnd: function ($obj) {
        var tmp = $obj.val();
        $obj.val('');
        $obj.focus();
        $obj.val(tmp);
    }
});