/*
 * Copyright (c) 2022 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

"use strict";

var comala          = require('comala');
var Handlebars      = require("hbsfy/runtime");

Handlebars.registerHelper('getText',function(key, options){
    return AJS.I18n.getText.apply(AJS.I18n, arguments);
});

module.exports = _.extend(comala, {
    //disable Almond temporarily
    noAMD: function(callback) {
        var cache = null;
        if (typeof define === 'function') {
            cache = define.amd;
            define.amd = null;
            callback();
            define.amd = cache;
        } else {
            callback();
        }
    },

    //Note to Mike: Overriding skull's resize method because of the forced 50px padding.
    resize: function (height, padding) {
        var iframeHeight = _.isNumber(height) && height > 0 ? height : AJS.$('html').outerHeight(true);

        if (_.isNumber(padding) && padding > 0) {
            iframeHeight += padding;
        }
        AJS.$(window.frameElement).attr('height', iframeHeight + 'px');
    },

    dialog: require('./components/dialog')
});
