/*
 * Decompiled with CFR 0.152.
 */
package org.randombits.confluence.intercom.tracker;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.randombits.confluence.intercom.ConnectionBundle;
import org.randombits.confluence.intercom.LocalIntercom4;
import org.randombits.confluence.intercom.LocalIntercomListener;
import org.randombits.confluence.intercom.tracker.Filter;
import org.randombits.confluence.intercom.tracker.TrackerConnection;
import org.randombits.confluence.intercom.tracker.TrackerListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tracker<Value>
implements LocalIntercomListener,
Iterable<Value> {
    private final Class<Value> valueType;
    private final Comparator<? super Value> comparator;
    private final Filter<? super Value> filter;
    private final Set<Value> mValues;
    private final Set<Value> uValues;
    private final SortedSet<Value> uSortedValues;
    private List<TrackerListener<? super Value>> listeners;

    public Tracker(Class<Value> thingType) {
        this(thingType, null, null);
    }

    public Tracker(Class<Value> thingType, Filter<? super Value> filter) {
        this(thingType, null, filter);
    }

    public Tracker(Class<Value> thingType, Comparator<? super Value> comparator) {
        this(thingType, comparator, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tracker(Class<Value> valueType, Comparator<? super Value> comparator, Filter<? super Value> filter) {
        LocalIntercom4 intercom;
        this.valueType = valueType;
        this.comparator = comparator;
        this.filter = filter;
        if (comparator == null) {
            this.mValues = new HashSet<Value>();
            this.uSortedValues = null;
        } else {
            TreeSet<Value> sortedValues = new TreeSet<Value>(comparator);
            this.mValues = sortedValues;
            this.uSortedValues = Collections.unmodifiableSortedSet(sortedValues);
        }
        this.uValues = Collections.unmodifiableSet(this.mValues);
        LocalIntercom4 localIntercom4 = intercom = LocalIntercom4.getInstance();
        synchronized (localIntercom4) {
            this.addValues(intercom.findConnections(TrackerConnection.class));
            intercom.addLocalIntercomListener(this);
        }
    }

    public Comparator<? super Value> getComparator() {
        return this.comparator;
    }

    public void addListener(TrackerListener<? super Value> listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<TrackerListener<? super Value>>();
        }
        this.listeners.add(listener);
    }

    public boolean removeListener(TrackerListener<? super Value> listener) {
        if (this.listeners == null) {
            return false;
        }
        return this.listeners.remove(listener);
    }

    private void addValues(Collection<TrackerConnection> connections) {
        if (connections != null) {
            for (TrackerConnection p : connections) {
                this.addValue(p.getValue(this.valueType));
            }
        }
    }

    private void addValues(TrackerConnection ... connections) {
        if (connections != null) {
            for (TrackerConnection p : connections) {
                this.addValue(p.getValue(this.valueType));
            }
        }
    }

    private void addValue(Value value) {
        if (value != null && (this.filter == null || this.filter.matches(value)) && this.mValues.add(value) && this.listeners != null) {
            for (TrackerListener<Value> listener : this.listeners) {
                listener.valueAdded(value);
            }
        }
    }

    public Set<Value> getValues() {
        return this.uValues;
    }

    public SortedSet<Value> getSortedValues() {
        return this.uSortedValues;
    }

    public Class<Value> getValueType() {
        return this.valueType;
    }

    @Override
    public synchronized void addedConnectionBundle(ConnectionBundle bundle) {
        this.addValues((TrackerConnection[])bundle.getConnections(TrackerConnection.class));
    }

    @Override
    public synchronized void removedConnectionBundle(ConnectionBundle bundle) {
        this.removeValues((TrackerConnection[])bundle.getConnections(TrackerConnection.class));
    }

    private void removeValues(TrackerConnection ... connections) {
        if (connections != null) {
            for (TrackerConnection p : connections) {
                this.removeValue(p.getValue(this.valueType));
            }
        }
    }

    private void removeValue(Value value) {
        if (value != null && this.mValues.remove(value) && this.listeners != null) {
            for (TrackerListener<Value> listener : this.listeners) {
                listener.valueRemoved(value);
            }
        }
    }

    @Override
    public Iterator<Value> iterator() {
        return this.getValues().iterator();
    }
}

