/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.model;

import com.atlassian.confluence.event.events.ConfluenceEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostUpdateEvent;
import com.atlassian.confluence.event.events.content.page.PageUpdateEvent;
import com.comalatech.confluence.workflow.ValueStore;
import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflow.model.BooleanCondition;
import com.comalatech.confluence.workflowcontainer.model.SerializableMacro;

public class IsMinorChangeCondition
extends BooleanCondition {
    public IsMinorChangeCondition(boolean not, String value) {
        super(not, value);
    }

    @Override
    protected boolean evaluateBinary(ValueStore valueStore) throws WorkflowException {
        ConfluenceEvent event = valueStore.getEvent();
        if (event == null) {
            return false;
        }
        if (event instanceof PageUpdateEvent) {
            PageUpdateEvent pageUpdateEvent = (PageUpdateEvent)event;
            return pageUpdateEvent.isMinorEdit();
        }
        if (event instanceof BlogPostUpdateEvent) {
            BlogPostUpdateEvent blogPostUpdateEvent = (BlogPostUpdateEvent)event;
            return blogPostUpdateEvent.isMinorEdit();
        }
        return false;
    }

    @Override
    public void addMacroParameters(SerializableMacro macro) {
        macro.addParameter("isminorchange", (Object)(!this.not ? 1 : 0));
    }

    @Override
    public String toString(ValueStore valueStore) {
        return "update is " + (this.not ? " not " : "") + " a minor change";
    }
}

