/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow;

import com.comalatech.confluence.workflow.WorkflowConfigurationManager;
import com.comalatech.confluence.workflow.model.WorkflowConfiguration;
import com.opensymphony.oscache.base.NeedsRefreshException;
import com.opensymphony.oscache.general.GeneralCacheAdministrator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfiniteLoopWatchdog {
    private static final Logger log = LoggerFactory.getLogger(InfiniteLoopWatchdog.class);
    private final GeneralCacheAdministrator counters;
    private int thresholdInSeconds;
    private int maxRequests;
    private int maxCount = 0;
    private final WorkflowConfigurationManager workflowConfigurationManager;

    public InfiniteLoopWatchdog(WorkflowConfigurationManager workflowConfigurationManager) {
        this.workflowConfigurationManager = workflowConfigurationManager;
        this.counters = new GeneralCacheAdministrator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasExceededThreshold(String user, String pageId) {
        this.checkWorkflowConfigurationValues();
        String key = user + ":" + pageId;
        int counter = 1;
        try {
            counter = (Integer)this.counters.getFromCache(key, this.thresholdInSeconds);
            if (++counter > this.maxCount) {
                ++this.maxCount;
                log.info("Max count reached " + this.maxCount + " on key " + key);
            }
            if (counter > this.maxRequests) {
                boolean bl = true;
                return bl;
            }
        }
        catch (NeedsRefreshException e) {
            this.counters.cancelUpdate(key);
        }
        finally {
            try {
                this.counters.putInCache(key, (Object)counter);
            }
            catch (Exception e2) {
                this.counters.cancelUpdate(key);
                log.error("Error adding counter to " + key);
            }
        }
        return false;
    }

    public int getThresholdInSeconds() {
        return this.thresholdInSeconds;
    }

    public void setThresholdInSeconds(int thresholdInSeconds) {
        this.thresholdInSeconds = thresholdInSeconds;
    }

    public int getMaxRequests() {
        return this.maxRequests;
    }

    public void setMaxRequests(int maxRequests) {
        this.maxRequests = maxRequests;
    }

    public int getMaxCount() {
        return this.maxCount;
    }

    private void checkWorkflowConfigurationValues() {
        WorkflowConfiguration workflowConfiguration = this.workflowConfigurationManager.getConfiguration();
        this.setThresholdInSeconds(workflowConfiguration.getThresholdInSeconds());
        this.setMaxRequests(workflowConfiguration.getMaxEvents());
    }
}

