/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.states.event;

import com.atlassian.confluence.event.events.content.blogpost.BlogPostEvent;
import com.atlassian.confluence.pages.BlogPost;
import com.comalatech.confluence.states.event.StateTransitionEvent;
import com.comalatech.confluence.states.model.Activity;
import com.comalatech.confluence.states.model.PageState;
import com.comalatech.confluence.timers.TimerUtils;

public class BlogPostStateTransitionEvent
extends BlogPostEvent
implements StateTransitionEvent {
    private PageState oldState;
    private PageState newState;

    public BlogPostStateTransitionEvent(Object src, BlogPost blogPost, PageState oldState, PageState newState) {
        super(src, blogPost);
        this.oldState = oldState;
        this.newState = newState;
    }

    @Override
    public PageState getPreviousEvent() {
        return this.oldState;
    }

    @Override
    public PageState getState() {
        return this.newState;
    }

    public String toString() {
        if (this.newState == null || this.getContent() == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer(TimerUtils.logDate(this.newState.getDate())).append(" ").append(this.getContent());
        if (this.oldState != null) {
            sb.append(" changed from ").append(this.oldState.getState()).append(" to ").append(this.newState.getState());
        } else {
            sb.append(" changed to ").append(this.newState.getState());
        }
        sb.append(" ").append(Activity.toString(this.newState));
        return sb.toString();
    }
}

