/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhocworkflows.rest;

import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.user.User;
import com.comalatech.confluence.users.CrowdSearchManager;
import com.comalatech.confluence.users.UserSearchManager;
import com.comalatech.confluence.workflow.WorkflowAdvancedConfigurationManager;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/search")
public class SearchResources {
    private static final Logger log = LoggerFactory.getLogger(SearchResources.class);
    public static final int MAX_RESULTS = 15;
    private final PermissionManager permissionManager;
    protected final CrowdSearchManager crowdSearchManager;

    public SearchResources(CrowdService crowdService, UserAccessor userAccessor, PermissionManager permissionManager, WorkflowAdvancedConfigurationManager workflowAdvancedConfigurationManager, UserSearchManager userSearchManager) {
        this.permissionManager = permissionManager;
        this.crowdSearchManager = new CrowdSearchManager(workflowAdvancedConfigurationManager, crowdService, userAccessor, userSearchManager);
    }

    @GET
    @Produces(value={"application/xml", "application/json"})
    @Path(value="/user")
    public Response doUserSearch(@QueryParam(value="query") String query, @QueryParam(value="users") String users, @QueryParam(value="groups") String groups, @QueryParam(value="excludedUsers") String excludedUsers) {
        try {
            if (!this.permissionManager.hasPermission((User)AuthenticatedUserThreadLocal.get(), Permission.VIEW, PermissionManager.TARGET_PEOPLE_DIRECTORY)) {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
            }
            return Response.ok((Object)this.crowdSearchManager.userSearch(query, users, groups, excludedUsers)).build();
        }
        catch (Exception e) {
            log.error("Error performing user search with => query: " + query + " | userFilter: " + users + " | groupFilter: " + groups + " | excludedUsers: " + excludedUsers, (Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
    }
}

