/*
 * Copyright (c) 2022 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

"use strict";

module.exports = Backbone.View.extend({
    tagName: 'table',
    className: 'aui cml-table',
    template: require('../../templates/hbs/table.hbs'),
    headers: [],

    initialize: function (options) {
        this.headers = options.headers;
    },

    render: function () {
        this.$el.html(this.template({
            headers: this.headers
        }));
        this.$tbody = this.$('tbody');
        return this.el;
    },

    row: function (html) {
        if(arguments.length > 0) {
            this.$tbody.append(html);
        }
        else {
            this.$tbody.empty();
        }
    }
});