/*
 * Decompiled with CFR 0.152.
 */
package org.randombits.util;

import java.nio.CharBuffer;
import org.randombits.util.TextBuffer;
import org.randombits.util.TextComparator;

public class DigitProcessor
implements TextComparator.Processor {
    private Long getValue(CharBuffer text) {
        TextBuffer out = new TextBuffer();
        while (text.hasRemaining() && this.isDigit(text.charAt(0))) {
            out.add(text.get());
        }
        if (out.length() == 0) {
            throw new IllegalArgumentException("Expected digit: " + text);
        }
        return Long.valueOf(out.toString());
    }

    private boolean isDigit(char c) {
        return Character.isDigit(c);
    }

    public boolean canProcess(CharBuffer text) {
        return text.hasRemaining() && this.isDigit(text.get());
    }

    public int compare(CharBuffer text1, CharBuffer text2) {
        Long v1 = this.getValue(text1);
        Long v2 = this.getValue(text2);
        return v1.compareTo(v2);
    }
}

