/*
 * Decompiled with CFR 0.152.
 */
package org.randombits.storage.confluence;

import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.user.User;
import com.opensymphony.module.propertyset.PropertySet;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.randombits.storage.BasedStorage;
import org.randombits.storage.StorageException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserStorage
extends BasedStorage {
    private User user;
    private PropertySet propertySet;
    private UserAccessor userAccessor;

    public UserStorage(User user) {
        super(BasedStorage.BoxType.Virtual);
        this.user = user;
        this.propertySet = this.getUserAccessor().getPropertySet(user);
    }

    private UserAccessor getUserAccessor() {
        if (this.userAccessor == null) {
            this.userAccessor = (UserAccessor)ContainerManager.getComponent((String)"userAccessor");
        }
        return this.userAccessor;
    }

    @Override
    protected Set<String> baseNameSet() {
        return new HashSet<String>(this.propertySet.getKeys());
    }

    @Override
    protected Boolean getBaseBoolean(String string) {
        return this.propertySet.getBoolean(string);
    }

    @Override
    protected Date getBaseDate(String name) {
        return this.propertySet.getDate(name);
    }

    @Override
    protected Double getBaseDouble(String name) {
        return new Double(this.propertySet.getDouble(name));
    }

    @Override
    protected Integer getBaseInteger(String name) {
        return new Integer(this.propertySet.getInt(name));
    }

    @Override
    protected Long getBaseLong(String name) {
        return new Long(this.propertySet.getLong(name));
    }

    @Override
    protected Number getBaseNumber(String name) {
        return this.toType(this.propertySet.getAsActualType(name), null, Number.class);
    }

    @Override
    protected Object getBaseObject(String name) {
        return this.propertySet.getObject(name);
    }

    @Override
    protected List<?> getBaseObjectList(String name) {
        return this.toType(this.propertySet.getObject(name), null, List.class);
    }

    @Override
    protected String getBaseString(String name) {
        return this.propertySet.getString(name);
    }

    @Override
    protected String[] getBaseStringArray(String name) throws StorageException {
        return this.toType(this.propertySet.getObject(name), null, String[].class);
    }

    @Override
    protected void setBaseBoolean(String name, Boolean value) {
        if (value != null) {
            this.propertySet.setBoolean(name, value.booleanValue());
        } else {
            this.propertySet.remove(name);
        }
    }

    @Override
    protected void setBaseDate(String name, Date value) {
        if (value != null) {
            this.propertySet.setDate(name, value);
        } else {
            this.propertySet.remove(name);
        }
    }

    @Override
    protected void setBaseDouble(String name, Double value) {
        if (value != null) {
            this.propertySet.setDouble(name, value.doubleValue());
        } else {
            this.propertySet.remove(name);
        }
    }

    @Override
    protected void setBaseInteger(String name, Integer value) {
        if (value != null) {
            this.propertySet.setInt(name, value.intValue());
        } else {
            this.propertySet.remove(name);
        }
    }

    @Override
    protected void setBaseLong(String name, Long value) {
        if (value != null) {
            this.propertySet.setLong(name, value.longValue());
        } else {
            this.propertySet.remove(name);
        }
    }

    @Override
    protected void setBaseObject(String name, Object value) {
        if (value != null) {
            this.propertySet.setObject(name, value);
        } else {
            this.propertySet.remove(name);
        }
    }

    @Override
    protected void setBaseObjectList(String name, List<?> value) {
        this.setBaseObject(name, value);
    }

    @Override
    protected void setBaseString(String name, String value) {
        if (value != null) {
            this.propertySet.setString(name, value);
        } else {
            this.propertySet.remove(name);
        }
    }

    @Override
    protected void setBaseStringArray(String name, String[] value) {
        this.setBaseObject(name, value);
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    public User getUser() {
        return this.user;
    }
}

