/*
 * Decompiled with CFR 0.152.
 */
package org.randombits.confluence.filtering.criteria.content;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.links.linktypes.AbstractContentEntityLink;
import com.atlassian.confluence.links.linktypes.AttachmentLink;
import com.atlassian.confluence.links.linktypes.PageCreateLink;
import com.atlassian.confluence.links.linktypes.ShortcutLink;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.renderer.links.UnpermittedLink;
import com.atlassian.renderer.links.UnresolvedLink;
import com.atlassian.renderer.links.UrlLink;
import java.util.HashMap;
import java.util.Map;
import org.randombits.confluence.filtering.criteria.CriteriaException;
import org.randombits.confluence.filtering.criteria.Criterion;
import org.randombits.confluence.filtering.criteria.CriterionInterpreter;

public class ContentTypeCriterion
implements Criterion {
    private String contentType;
    public static final String UNRESOLVED_TYPE = "unresolved";
    public static final String MAILTO_TYPE = "mailto";
    public static final String URL_TYPE = "url";
    public static final String SPACE_TYPE = "space";

    public ContentTypeCriterion(String contentType) {
        this.contentType = contentType;
    }

    public boolean matches(Object object) {
        String objectType = null;
        if (object instanceof UnpermittedLink) {
            object = ((UnpermittedLink)object).getWrappedLink();
        } else if (object instanceof AbstractContentEntityLink) {
            if (object instanceof PageCreateLink) {
                objectType = "page";
            } else {
                object = ((AbstractContentEntityLink)object).getDestinationContent();
            }
        } else if (object instanceof AttachmentLink) {
            object = ((AttachmentLink)object).getAttachment();
        } else if (object instanceof UnresolvedLink) {
            objectType = UNRESOLVED_TYPE;
        } else if (object instanceof UrlLink) {
            UrlLink urlLink = (UrlLink)object;
            objectType = ContentTypeCriterion.isMailLink(urlLink) ? MAILTO_TYPE : URL_TYPE;
        } else if (object instanceof ShortcutLink) {
            objectType = URL_TYPE;
        }
        if (object instanceof ContentEntityObject) {
            ContentEntityObject content = (ContentEntityObject)object;
            objectType = content.getType();
        } else if (object instanceof Attachment) {
            objectType = ((Attachment)object).getType();
        } else if (object instanceof Space) {
            objectType = SPACE_TYPE;
        } else if (object instanceof String) {
            objectType = (String)object;
        }
        return this.contentType.equalsIgnoreCase(objectType);
    }

    public String getContentType() {
        return this.contentType;
    }

    public static boolean isMailLink(UrlLink link) {
        return link.getUrl().startsWith("mailto:");
    }

    public String toString() {
        return "{content type: " + this.contentType + "}";
    }

    public static class Interpeter
    implements CriterionInterpreter {
        private static final Map<String, String> TYPES = new HashMap<String, String>();

        public Criterion createCriterion(String value) throws CriteriaException {
            String type = TYPES.get(value.toLowerCase());
            if (type == null) {
                throw new CriteriaException("Unsupported content type: " + value);
            }
            return new ContentTypeCriterion(type);
        }

        static {
            TYPES.put("page", "page");
            TYPES.put("blogpost", "blogpost");
            TYPES.put("news", "blogpost");
            TYPES.put("spacedescription", "spacedesc");
            TYPES.put("comment", "comment");
            TYPES.put("attachment", "attachment");
            TYPES.put("mail", "mail");
            TYPES.put(ContentTypeCriterion.SPACE_TYPE, ContentTypeCriterion.SPACE_TYPE);
            TYPES.put(ContentTypeCriterion.MAILTO_TYPE, ContentTypeCriterion.MAILTO_TYPE);
            TYPES.put(ContentTypeCriterion.URL_TYPE, ContentTypeCriterion.URL_TYPE);
            TYPES.put(ContentTypeCriterion.UNRESOLVED_TYPE, ContentTypeCriterion.UNRESOLVED_TYPE);
        }
    }
}

