/*
 * Decompiled with CFR 0.152.
 */
package net.customware.confluence.reporting;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.spaces.Space;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.customware.confluence.reporting.Report;
import net.customware.confluence.reporting.ReportBuilder;
import net.customware.confluence.reporting.ReportException;
import net.customware.confluence.reporting.ReportOutput;
import net.customware.confluence.reporting.ReportSetup;
import net.customware.confluence.reporting.query.Query;
import org.randombits.confluence.filtering.criteria.Criteria;

public class DefaultReport<S extends ReportSetup<O>, O extends ReportOutput>
implements Report<S, O> {
    private Report<?, ?> parent;
    private Object currentItem;
    private ContentEntityObject content;
    private PageContext pageContext;
    private Exception queryException;
    private long currentItemNumber;
    private S setup;
    private Map<String, Object> attributes;

    public DefaultReport(S setup) {
        this.setup = setup;
    }

    @Override
    public void setParent(Report<?, ?> parent) {
        this.parent = parent;
    }

    @Override
    public S getSetup() {
        return this.setup;
    }

    public Criteria getCriteria() {
        return this.setup.getCriteria();
    }

    @Override
    public List<O> getOutputs() {
        return this.setup.getOutputs();
    }

    @Override
    public Object getCurrentItem() {
        return this.currentItem;
    }

    @Override
    public void setCurrentItem(Object newItem) {
        this.currentItem = newItem;
        ++this.currentItemNumber;
        if (this.currentItem == null) {
            this.content = null;
        } else if (this.currentItem instanceof ContentEntityObject) {
            this.content = (ContentEntityObject)this.currentItem;
        } else if (this.currentItem instanceof Space) {
            this.content = ((Space)this.currentItem).getDescription();
        } else if (this.currentItem instanceof Attachment) {
            this.content = ((Attachment)this.currentItem).getContent();
        }
        this.pageContext = null;
    }

    @Override
    public long getCurrentItemNumber() {
        return this.currentItemNumber;
    }

    public Exception getQueryException() {
        return this.queryException;
    }

    public void setQueryException(Exception reporterException) {
        this.queryException = reporterException;
    }

    @Override
    public ContentEntityObject getContent() throws ReportException {
        if (this.content != null) {
            return this.content;
        }
        if (this.parent != null) {
            return this.parent.getContent();
        }
        return ReportBuilder.getRootContent();
    }

    @Override
    public PageContext getPageContext() throws ReportException {
        if (this.pageContext == null) {
            ContentEntityObject contextEntity;
            PageContext pageContext = this.pageContext = this.parent != null ? this.parent.getPageContext() : null;
            if (this.pageContext == null) {
                this.pageContext = ReportBuilder.getRootPageContext();
            }
            ContentEntityObject contentEntityObject = contextEntity = this.pageContext == null ? null : this.pageContext.getEntity();
            if (this.pageContext == null || this.content != null && !this.content.equals((Object)contextEntity)) {
                this.pageContext = new PageContext(this.content, this.pageContext);
            }
        }
        return this.pageContext;
    }

    @Override
    public Report<?, ?> getParent() {
        return this.parent;
    }

    @Override
    public Query<? extends Object> getQuery() {
        return this.setup.getQuery();
    }

    @Override
    public Object getAttribute(String name) {
        if (this.attributes != null) {
            return this.attributes.get(name);
        }
        return null;
    }

    @Override
    public Collection<String> getAttributeNames() {
        if (this.attributes != null) {
            return this.attributes.keySet();
        }
        return Collections.EMPTY_SET;
    }

    @Override
    public void setAttribute(String name, Object value) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>();
        }
        this.attributes.put(name, value);
    }
}

