/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.restv2.resources;

import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.SimplePageRequest;
import com.atlassian.confluence.api.model.search.SearchOptions;
import com.atlassian.confluence.api.model.search.SearchPageResponse;
import com.atlassian.confluence.api.model.search.SearchResult;
import com.atlassian.confluence.api.service.search.CQLSearchService;
import com.atlassian.confluence.rest.api.model.ExpansionsParser;
import com.comalatech.confluence.workflow.documentReport.DocumentReportService;
import com.comalatech.confluence.workflow.restv2.model.documentreport.DocumentReport;
import com.webcohesion.enunciate.metadata.rs.ResponseCode;
import com.webcohesion.enunciate.metadata.rs.StatusCodes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/report")
public class WorflowsReportResource {
    private static final Logger log = LoggerFactory.getLogger(WorflowsReportResource.class);
    private final CQLSearchService cqlSearchService;
    private final DocumentReportService documentReportService;

    public WorflowsReportResource(CQLSearchService cqlSearchService, DocumentReportService documentReportService) {
        this.cqlSearchService = cqlSearchService;
        this.documentReportService = documentReportService;
    }

    @Path(value="/search")
    @Produces(value={"application/json"})
    @GET
    @StatusCodes(value={@ResponseCode(code=500, condition="Exception when trying to retrieve data for DocumentReport")})
    public Response search(@QueryParam(value="cql") String cql, @QueryParam(value="expand") String expand, @QueryParam(value="start") int start, @QueryParam(value="limit") int limit) {
        try {
            SearchPageResponse search = this.cqlSearchService.search(cql, SearchOptions.buildDefault(), (PageRequest)new SimplePageRequest(start, limit), ExpansionsParser.parse((String)expand));
            DocumentReport documentReport = this.documentReportService.buildDocumentReportModelFromCqlResponse((SearchPageResponse<SearchResult>)search);
            return Response.ok((Object)documentReport).build();
        }
        catch (Exception e) {
            log.error("Unable to retrieve data for DocumentReport CQL: {} , expand: {} , start: {} ,limit: {} ", new Object[]{cql, expand, start, limit, e});
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)StringEscapeUtils.escapeHtml4((String)e.getMessage())).build();
        }
    }
}

