/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.mywork.notification.task;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.comalatech.confluence.util.FancyDateFormatter;
import com.comalatech.confluence.workflow.mywork.notification.task.AbstractTaskNotification;
import com.comalatech.workflow.event.TaskAssignEvent;
import org.codehaus.jackson.node.ObjectNode;

public class TaskAssigneeNotification
extends AbstractTaskNotification {
    TaskAssignEvent event;

    public TaskAssigneeNotification(TaskAssignEvent event) {
        super(event);
        this.event = event;
    }

    @Override
    public String getItemTitle() {
        return this.event.getTask().getName();
    }

    @Override
    public String getDescription() {
        return this.event.getAssignment().getComment();
    }

    @Override
    public String getAction() {
        return "assigned";
    }

    @Override
    public ObjectNode getMetadata(String toUser) {
        ObjectNode metadata = super.getMetadata(toUser);
        if (this.event.getTask().getDueDate() != null) {
            String dueDate = FancyDateFormatter.decorateDateTimePretty(this.event.getTask().getDueDate(), false);
            metadata.put("duedate", ConfluenceActionSupport.getTextStatic((String)"comalatech.awp.tasks.dueDate") + " " + dueDate);
        } else {
            metadata.put("duedate", "");
        }
        return metadata;
    }
}

