/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.model;

import com.atlassian.confluence.pages.AbstractPage;
import java.io.Serializable;
import java.util.Arrays;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;

public class WorkflowConfiguration
implements Serializable {
    private static final long serialVersionUID = -5607828369728123544L;
    private String[] pageApprovalsSpaceKeys = new String[0];
    private boolean isPageApprovalsRestricted;
    private String[] spaceWorkflowSpaceKeys;
    private boolean isSpaceWorkflowRestricted;
    private int thresholdInSeconds;
    private int maxEvents;
    private String version;
    private boolean showWelcome;
    private String welcomeUrl;
    private String pluginVersion;
    private int pluginVersionNumber;
    private String workflowVersionNumber;
    private String workflowVersionName;
    private String workflowAuthor;
    private String workflowLogo;
    private transient boolean anyPageApprovals;
    private transient boolean anySpaceWorkflows;
    private static int confluenceUsers;
    private static String organisation;
    private boolean onboardEnable;

    public WorkflowConfiguration(WorkflowConfiguration config) {
        this();
        this.setVersion(config.getVersion());
    }

    public WorkflowConfiguration() {
    }

    public boolean isAnySpacePageApprovals() {
        return this.anyPageApprovals;
    }

    public boolean isAnySpaceWorkflows() {
        return this.anySpaceWorkflows;
    }

    public void init() {
        if (this.pageApprovalsSpaceKeys == null) {
            this.pageApprovalsSpaceKeys = new String[0];
        }
        if (this.spaceWorkflowSpaceKeys == null) {
            this.spaceWorkflowSpaceKeys = new String[0];
        }
        Arrays.sort(this.pageApprovalsSpaceKeys);
        Arrays.sort(this.spaceWorkflowSpaceKeys);
        this.anyPageApprovals = this.hasAnySpace(this.pageApprovalsSpaceKeys);
        this.anySpaceWorkflows = this.hasAnySpace(this.spaceWorkflowSpaceKeys);
    }

    private boolean hasAnySpace(String[] spaceKeys) {
        for (String allowedSpace : spaceKeys) {
            if (!allowedSpace.equalsIgnoreCase("any")) continue;
            return true;
        }
        return false;
    }

    public boolean isPageApprovalsAllowed(AbstractPage page) {
        return this.isPageApprovalsAllowed(page.getSpaceKey());
    }

    public boolean isPageApprovalsAllowed(String spaceKey) {
        return this.checkRestriction(spaceKey, this.anyPageApprovals, this.isPageApprovalsRestricted, this.pageApprovalsSpaceKeys);
    }

    public boolean isSpaceWorkflowsAllowed(String spaceKey) {
        return this.checkRestriction(spaceKey, this.anySpaceWorkflows, this.isSpaceWorkflowRestricted, this.spaceWorkflowSpaceKeys);
    }

    private boolean checkRestriction(String spaceKey, boolean any, boolean isRestricted, String[] keys) {
        if (any) {
            return !isRestricted;
        }
        if (StringUtils.isBlank((String)spaceKey)) {
            return isRestricted;
        }
        return Arrays.asList(keys).contains(spaceKey) ^ isRestricted;
    }

    public String getPageApprovalsSpaceKeysAsString() {
        return StringUtils.join((Object[])this.pageApprovalsSpaceKeys, (char)',');
    }

    public String[] getPageApprovalsSpaceKeys() {
        return this.pageApprovalsSpaceKeys;
    }

    public String[] getSpaceWorkflowSpaceKeys() {
        return this.spaceWorkflowSpaceKeys;
    }

    public boolean getPageApprovalsRestricted() {
        return this.isPageApprovalsRestricted;
    }

    public boolean getSpaceWorkflowRestricted() {
        return this.isSpaceWorkflowRestricted;
    }

    public String getSpaceWorkflowSpaceKeysAsString() {
        return StringUtils.join((Object[])this.spaceWorkflowSpaceKeys, (char)',');
    }

    public void setSpaceWorkflowSpaceKeys(String[] spaceWorkflowSpaceKeys) {
        this.spaceWorkflowSpaceKeys = spaceWorkflowSpaceKeys;
    }

    public void setPageApprovalsSpaceKeys(String[] pageApprovalsSpaceKeys) {
        this.pageApprovalsSpaceKeys = pageApprovalsSpaceKeys;
    }

    public void setSpaceWorkflowRestricted(boolean restricted) {
        this.isSpaceWorkflowRestricted = restricted;
    }

    public void setPageApprovalsRestricted(boolean restricted) {
        this.isPageApprovalsRestricted = restricted;
    }

    public int getThresholdInSeconds() {
        return this.thresholdInSeconds;
    }

    public void setThresholdInSeconds(int thresholdInSeconds) {
        this.thresholdInSeconds = thresholdInSeconds;
    }

    public int getMaxEvents() {
        return this.maxEvents;
    }

    public void setMaxEvents(int maxEvents) {
        this.maxEvents = maxEvents;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void incrementVersion() {
        long v;
        try {
            v = Long.parseLong(this.version);
        }
        catch (Exception e) {
            v = 0L;
        }
        this.version = Long.toString(++v);
    }

    public int getPluginVersionNumber() {
        return this.pluginVersionNumber;
    }

    public String getWorkflowVersionNumber() {
        return this.workflowVersionNumber;
    }

    public String getWorkflowVersionName() {
        return this.workflowVersionName;
    }

    public static void setConfluenceUsers(int confluenceUsers) {
        WorkflowConfiguration.confluenceUsers = confluenceUsers;
    }

    public int getConfluenceUsers() {
        return confluenceUsers;
    }

    public static void setOrganisation(String organisation) {
        WorkflowConfiguration.organisation = organisation;
    }

    public static String getOrganisation() {
        return organisation;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public String getPluginVersion() {
        return this.pluginVersion;
    }

    public boolean isShowWelcome() {
        return this.showWelcome;
    }

    public String getWelcomeUrl() {
        return this.welcomeUrl;
    }

    public void setPluginVersion(String pluginVersion) {
        this.pluginVersion = pluginVersion;
    }

    public void setPluginVersionNumber(int pluginVersionNumber) {
        this.pluginVersionNumber = pluginVersionNumber;
    }

    public void setWorkflowVersionNumber(String workflowVersionNumber) {
        this.workflowVersionNumber = workflowVersionNumber;
    }

    public void setWorkflowVersionName(String workflowVersionName) {
        this.workflowVersionName = workflowVersionName;
    }

    public boolean isOnboardEnable() {
        return this.onboardEnable;
    }

    public void setOnboardEnable(boolean onboardEnable) {
        this.onboardEnable = onboardEnable;
    }

    public String getWorkflowAuthor() {
        return this.workflowAuthor;
    }

    public void setWorkflowAuthor(String workflowAuthor) {
        this.workflowAuthor = workflowAuthor;
    }

    public String getWorkflowLogo() {
        return this.workflowLogo;
    }

    public void setWorkflowLogo(String workflowLogo) {
        this.workflowLogo = workflowLogo;
    }
}

