/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.audit.dao;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.confluence.setup.bandana.KeyedBandanaContext;
import com.comalatech.confluence.adhoc.dao.ComalatechBandanaContext;
import com.comalatech.confluence.util.JsonSerialiserUtil;
import com.comalatech.confluence.workflow.audit.AuditRecordImpl;
import com.comalatech.confluence.workflow.audit.dao.WorkflowAuditLogDao;
import com.comalatech.workflow.audit.AuditRecord;
import com.google.common.collect.Lists;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class BandanaWorkflowAuditLogDao
implements WorkflowAuditLogDao {
    public static final String WORKFLOW_AUDIT_LOG_KEY = "com.comalatech.adocworkflows.auditlog";
    private final BandanaManager bandanaManager;
    private JsonSerialiserUtil<AuditRecordImpl> auditRecordSerialiser = new JsonSerialiserUtil<AuditRecordImpl>(AuditRecordImpl.class);

    public BandanaWorkflowAuditLogDao(BandanaManager bandanaManager) {
        this.bandanaManager = bandanaManager;
    }

    @Override
    public void saveAuditLogRecord(AuditRecord record) {
        String spaceKey = record.getSpaceKey();
        List<AuditRecordImpl> records = this.getAuditLogRecordsImpl(spaceKey);
        records.add(0, (AuditRecordImpl)record);
        String json = this.auditRecordSerialiser.serialiseList(records);
        KeyedBandanaContext context = this.makeContext(spaceKey);
        this.bandanaManager.setValue((BandanaContext)context, WORKFLOW_AUDIT_LOG_KEY, (Object)json);
    }

    private List<AuditRecordImpl> getAuditLogRecordsImpl(String spaceKey) {
        KeyedBandanaContext context = this.makeContext(spaceKey);
        String json = (String)this.bandanaManager.getValue((BandanaContext)context, WORKFLOW_AUDIT_LOG_KEY);
        if (TextUtils.stringSet((String)json)) {
            List<AuditRecordImpl> records = this.auditRecordSerialiser.deserialiseList(json);
            return records;
        }
        return Lists.newArrayList();
    }

    @Override
    public List<AuditRecord> getAuditLogRecords(String spaceKey) {
        KeyedBandanaContext context = this.makeContext(spaceKey);
        String json = (String)this.bandanaManager.getValue((BandanaContext)context, WORKFLOW_AUDIT_LOG_KEY);
        if (TextUtils.stringSet((String)json)) {
            ArrayList recordList = Lists.newArrayList();
            List<AuditRecordImpl> records = this.auditRecordSerialiser.deserialiseList(json);
            recordList.addAll(records);
            return recordList;
        }
        return Lists.newArrayList();
    }

    @Override
    public void removeAllRecords(@Nullable String spaceKey) {
        KeyedBandanaContext context = this.makeContext(spaceKey);
        this.bandanaManager.removeValue((BandanaContext)context, WORKFLOW_AUDIT_LOG_KEY);
    }

    private KeyedBandanaContext makeContext(String spaceKey) {
        return TextUtils.stringSet((String)spaceKey) ? new ConfluenceBandanaContext(spaceKey) : ComalatechBandanaContext.COMALATECH_CONTEXT;
    }
}

