/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.documentActivity.service.provider;

import com.atlassian.confluence.api.service.exceptions.NotFoundException;
import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.comalatech.confluence.documentActivity.domain.entities.ActionType;
import com.comalatech.confluence.documentActivity.service.model.DocumentActivityQuery;
import com.comalatech.confluence.documentActivity.service.model.DocumentActivityQueryFilter;
import com.comalatech.confluence.documentActivity.service.provider.AbstractActivityProvider;
import com.comalatech.confluence.documentActivity.util.ActorUtils;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;

public abstract class AbstractPageActivityProvider<T>
extends AbstractActivityProvider {
    protected final ContentEntityManager contentEntityManager;
    protected List<ActionType.Type> excludingTypes;
    protected ActionType.Type activityType;
    protected List<ActionType.Subtype> activitySubtypes;

    public AbstractPageActivityProvider(ContentEntityManager contentEntityManager, ActorUtils actorUtils) {
        super(actorUtils);
        this.contentEntityManager = contentEntityManager;
    }

    protected abstract boolean matchesFilters(T var1, DocumentActivityQuery var2);

    protected ContentEntityObject getContent(DocumentActivityQuery query) {
        if (query.getFilters().getTargetId() == null) {
            throw new IllegalArgumentException("Missing mandatory 'targetId' filter");
        }
        ContentEntityObject ceo = this.contentEntityManager.getById(query.getFilters().getTargetId().longValue());
        if (ceo == null) {
            throw new NotFoundException("There is no content entity with this id: " + query.getFilters().getTargetId());
        }
        return ceo;
    }

    @Override
    public boolean shouldApply(DocumentActivityQuery query) {
        DocumentActivityQueryFilter filters = query.getFilters();
        return filters == null || CollectionUtils.isEmpty(filters.getParticipant()) && CollectionUtils.isEmpty(filters.getStateNames()) && this.matchTypeAndSubtype(filters, this.activityType, this.activitySubtypes);
    }

    private boolean matchTypeAndSubtype(DocumentActivityQueryFilter filters, ActionType.Type type, List<ActionType.Subtype> subtypes) {
        return filters.getTypes() == null || filters.getTypes().stream().anyMatch(elem -> {
            boolean applied = elem.getType().equals(type.getValue());
            if (subtypes != null && !subtypes.isEmpty() && elem.getSubtypes() != null && !elem.getSubtypes().isEmpty()) {
                applied = applied && elem.getSubtypes().stream().anyMatch(subtype -> subtypes.contains((Object)ActionType.Subtype.fromString(subtype)));
            }
            return applied;
        });
    }
}

