/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.dataextractor;

import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.api.service.exceptions.ReadOnlyException;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.longrunning.ConfluenceAbstractLongRunningTask;
import com.atlassian.core.bean.EntityObject;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.comalatech.confluence.dataextractor.DataExtractorManager;
import com.comalatech.confluence.workflow.WorkflowAdvancedConfigurationManager;
import com.google.common.collect.Lists;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.commons.collections.SetUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataExtractorPopulationTask
extends ConfluenceAbstractLongRunningTask {
    private static final Logger log = LoggerFactory.getLogger(DataExtractorPopulationTask.class);
    public static final String NAME = DataExtractorPopulationTask.getTextStatic("awp.space.populateDataExtractor.task");
    private TransactionTemplate transactionTemplate;
    private DataExtractorManager dataExtractorManager;
    private PageManager pageManager;
    private AccessModeService accessModeService;
    private WorkflowAdvancedConfigurationManager workflowAdvancedConfigurationManager;
    private Set<Long> pageIds = SetUtils.EMPTY_SET;
    private Supplier<Set<Long>> pageIdSupplier;
    private int totalPagesWithErrors = 0;
    private int batchWithRollbackErrors = 0;
    private int totalUpdatedPages = 0;

    private DataExtractorPopulationTask() {
    }

    public static DataExtractorPopulationTask fromDeps(TransactionTemplate transactionTemplate, DataExtractorManager dataExtractorManager, PageManager pageManager, AccessModeService accessModeService, WorkflowAdvancedConfigurationManager workflowAdvancedConfigurationManager) {
        DataExtractorPopulationTask instance = new DataExtractorPopulationTask();
        instance.transactionTemplate = transactionTemplate;
        instance.dataExtractorManager = dataExtractorManager;
        instance.pageManager = pageManager;
        instance.accessModeService = accessModeService;
        instance.workflowAdvancedConfigurationManager = workflowAdvancedConfigurationManager;
        return instance;
    }

    public static String getTextStatic(String key) {
        ConfluenceActionSupport dummy = GeneralUtil.newWiredConfluenceActionSupport();
        return dummy.getText(key);
    }

    public static String getTextStatic(String key, Object[] list) {
        ConfluenceActionSupport dummy = GeneralUtil.newWiredConfluenceActionSupport();
        return dummy.getText(key, list);
    }

    public DataExtractorPopulationTask setPageIds(Set<Long> pageIds) {
        this.pageIds = pageIds;
        return this;
    }

    public DataExtractorPopulationTask setPageIdSupplier(Supplier<Set<Long>> pageIdSupplier) {
        this.pageIdSupplier = pageIdSupplier;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runInternal() {
        try {
            int batchSize = this.workflowAdvancedConfigurationManager.getDataExtractorBatchSize();
            if (this.pageIdSupplier != null) {
                this.pageIds = this.pageIdSupplier.get();
            }
            if (this.pageIds == null) {
                log.error("No pageIds have been provided, stopping here");
                return;
            }
            int totalBatches = this.pageIds.size() / batchSize;
            totalBatches += this.pageIds.size() % batchSize > 0 ? 1 : 0;
            int currentBatch = 1;
            for (List pageIdsSubList : Lists.partition(new ArrayList<Long>(this.pageIds), (int)batchSize)) {
                if (log.isDebugEnabled()) {
                    log.debug("Starting batch " + currentBatch + " out of " + totalBatches);
                }
                if (this.accessModeService.isReadOnlyAccessModeEnabled()) {
                    throw new ReadOnlyException(DataExtractorPopulationTask.getTextStatic("com.comalatech.readonlymode.long.running.task.error"));
                }
                try {
                    PopulateTransactionCallback ptc = new PopulateTransactionCallback(pageIdsSubList);
                    Integer batchPagesWithErrors = (Integer)this.transactionTemplate.execute((TransactionCallback)ptc);
                    this.totalUpdatedPages += pageIdsSubList.size() - batchPagesWithErrors;
                    this.totalPagesWithErrors += batchPagesWithErrors.intValue();
                    if (batchPagesWithErrors > 0) {
                        this.progress.setStatus(DataExtractorPopulationTask.getTextStatic("awp.space.populateDataExtractor.status.batch.validation", new Object[]{currentBatch, totalBatches, batchPagesWithErrors}));
                    } else {
                        this.progress.setStatus(DataExtractorPopulationTask.getTextStatic("awp.space.populateDataExtractor.status.batch", new Object[]{currentBatch, totalBatches}));
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("Batch " + currentBatch + " out of " + totalBatches + " successfully completed");
                    }
                }
                catch (Exception e) {
                    ++this.batchWithRollbackErrors;
                    this.totalPagesWithErrors += pageIdsSubList.size();
                    log.error("Batch number " + currentBatch + " of " + totalBatches + " failed with Exception and was rollback.", (Throwable)e);
                    log.error("List of pageIds that failed on batch number " + currentBatch + ": " + pageIdsSubList);
                    this.progress.setStatus(DataExtractorPopulationTask.getTextStatic("awp.space.populateDataExtractor.status.batch.failed", new Object[]{currentBatch, totalBatches}));
                }
                this.progress.setPercentage(currentBatch, totalBatches);
                ++currentBatch;
            }
            if (this.totalPagesWithErrors == 0) {
                this.progress.setStatus(DataExtractorPopulationTask.getTextStatic("awp.space.populateDataExtractor.status.completed"));
                if (log.isInfoEnabled()) {
                    log.info("Workflow Content Properties population task successfully completed for " + this.pageIds.size() + " pages");
                }
            } else {
                String jobSummaryMessage = MessageFormat.format("Workflow Content Properties population was completed. Summary: {0} pages of {1} where updated. {2} of {3} batches were successfully committed. {4} pages failed because of errors. Please check the logs and contact with Comalatech support.", this.totalUpdatedPages, this.pageIds.size(), totalBatches - this.batchWithRollbackErrors, totalBatches, this.totalPagesWithErrors);
                log.error(jobSummaryMessage);
                this.progress.setStatus(DataExtractorPopulationTask.getTextStatic("awp.space.populateDataExtractor.status.completed.validation", new Object[]{this.totalPagesWithErrors, this.pageIds.size()}));
            }
            this.progress.setCompletedSuccessfully(true);
        }
        catch (Exception e) {
            log.error("Unhandled exception while json population job", (Throwable)e);
            if (e.getMessage() != null) {
                this.progress.setStatus(DataExtractorPopulationTask.getTextStatic("awp.space.populateDataExtractor.status.error.exception", new Object[]{e.getMessage()}));
            } else {
                this.progress.setStatus(DataExtractorPopulationTask.getTextStatic("awp.space.populateDataExtractor.status.error"));
            }
            this.progress.setCompletedSuccessfully(false);
        }
        finally {
            this.progress.setPercentage(100);
        }
    }

    public String getNameKey() {
        return NAME;
    }

    public String getName() {
        return NAME;
    }

    class PopulateTransactionCallback
    implements TransactionCallback<Integer> {
        private final List<Long> pageIdsToPopulate;

        PopulateTransactionCallback(List<Long> pageIdsToPopulate) {
            this.pageIdsToPopulate = pageIdsToPopulate;
        }

        public Integer doInTransaction() {
            int pagesWithErrors = 0;
            for (Long pageId : this.pageIdsToPopulate) {
                try {
                    AbstractPage currentPage = DataExtractorPopulationTask.this.pageManager.getAbstractPage(pageId.longValue());
                    if (currentPage != null && DataExtractorPopulationTask.this.dataExtractorManager.updateAllContentProperties((EntityObject)currentPage, false)) continue;
                    ++pagesWithErrors;
                }
                catch (Exception e) {
                    ++pagesWithErrors;
                    log.error("Exception while trying to updateAllContentProperties for page id: " + pageId, (Throwable)e);
                }
            }
            return pagesWithErrors;
        }
    }
}

