/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.cloud.migration.usecases;

import com.comalatech.confluence.cloud.migration.entity.domain.activity.Activity;
import com.comalatech.confluence.cloud.migration.usecases.contracts.CloudPopulationData;
import com.comalatech.confluence.license.WorkflowsFeatureManager;
import com.comalatech.confluence.license.WorkflowsFeatureManagerImpl;
import java.util.Map;

public class CloudUserIdPopulationUseCase
implements CloudPopulationData {
    private final WorkflowsFeatureManager workflowsFeatureManager;
    public static final String USER_KEY_PREFIX = "confluence.userkey/";

    public CloudUserIdPopulationUseCase(WorkflowsFeatureManager workflowsFeatureManager) {
        this.workflowsFeatureManager = workflowsFeatureManager;
    }

    @Override
    public Activity populateCloudData(Activity activity, Map<String, String> contentMapping) {
        String serverId = activity.getAction().getPerformer().getServerId();
        if (contentMapping.containsKey(USER_KEY_PREFIX + serverId)) {
            activity.getAction().getPerformer().setCloudId(contentMapping.get(USER_KEY_PREFIX + serverId));
        } else if (WorkflowsFeatureManagerImpl.isWorkflowsUser(serverId)) {
            activity.getAction().getPerformer().setCloudId(this.workflowsFeatureManager.getPluginKey());
        } else if ("com.comalatech.anonymous".equals(serverId)) {
            activity.getAction().getPerformer().setCloudId("com.comalatech.anonymous");
        } else {
            activity.getAction().getPerformer().setCloudId("com.comalatech.deleted");
        }
        return activity;
    }
}

