/*
 * Copyright (c) 2022 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

(function(jQuery) {
    var defaults = {
        hint: "",
        allowNew : true
    };
    jQuery.fn.listPicker = function(options, callback) {
        var settings = jQuery.extend({}, defaults, options);
        var input = jQuery(this).find("input");
        var optionsList = jQuery(this).find("ul");

        optionsList.wrap("<div></div>");
        var optionsBox = optionsList.parent();
        if (settings.hint.length > 0) {
            optionsList.before("<div class='hint'>" + settings.hint + "</div");
        }
        input.after("<input type='hidden' name='default' value=''/>");
        var defaultValue = input.next();
        defaultValue.val(input.val());
        var listOptions = optionsBox.find("li");
        optionsBox.find("ul").addClass("list-picker-list");
        optionsBox.css("width",input.css("width"));
        listOptions.addClass("list-picker-option");
        input.addClass("list-picker");
        input.addClass("default");
        optionsBox.addClass("list-picker").addClass("hidden");
        input.focus(function() {
            if (input.hasClass("default")) {
                input.val("");
                input.removeClass("default");
            }
            optionsBox.removeClass("hidden");
        });
        input.blur(function() {
            setTimeout(function() {
                optionsBox.addClass("hidden");
                var value = input.val();
                if (value.length == 0) {
                    input.val(defaultValue.val()).addClass("default");
                }
                var newOption = true;
                listOptions.removeClass("hover").each(function() {
                    if (value == jQuery(this).html()) {
                        newOption = false;
                        return false;
                    }
                });
                if (newOption && ! input.hasClass("default")) {
                    input.addClass("new");
                } else {
                    input.removeClass("new");
                }
            },200);
        });
        listOptions.hover(function() {
            listOptions.removeClass("hover");
            jQuery(this).addClass("hover");
        }, function() {
            jQuery(this).removeClass("hover");
        });
        listOptions.click(function() {
            input.removeClass("default");
            input.val(jQuery(this).html());
            input.change();
            if (callback != undefined) {
                callback(jQuery(this));
            }
        });
        input.keydown(function(event) {
            if (event.keyCode == 40) {// arrow down
                var selected = optionsBox.find("li.hover");
                if (selected.length == 1) {
                    if (selected.next().length == 1) {
                        selected.removeClass("hover").next().addClass("hover").click();
                    }
                } else {
                    selected = optionsBox.find("li:first");
                    if (selected.length == 1) {
                        selected.addClass("hover").click();
                    }
                }
            } else if (event.keyCode == 38) {// arrow up
                var selected = optionsBox.find("li.hover");
                if (selected.length == 1) {
                    if (selected.prev().length == 1) {
                        selected.removeClass("hover").prev().addClass("hover").click();
                    }
                }
            } else if (event.keyCode == 13) { // enter
                input.blur();
            } else if (! settings.allowNew) {
                return false;
            }
        });


    }
})(jQuery);
