/*
 * Copyright (c) 2022 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

/**
 * #ApprovalTab
 *   #ApprovalTabDialog
 *   #ApprovalTabApprovers
 *   #ApprovalTabApprovals
 *   #ApprovalTabState
 */
var AWP = AWP || {};
AWP.View = AWP.View || {};


AWP.View.ApprovalTab = Backbone.View.extend({
    id : "approvals",
    icon: "workflow",
    caption: AJS.I18n.getText("adhocworkflows.tab.approvals"),
    innerContent: Backbone.View,
    
    config: function(options) {
        this.innerContent = options.innerContent;
        
        if(options.caption) {
            this.caption = options.caption;
        }
        else {
            this.caption = this.model.get("name");
        }
    },

    render: function() {
        this.$el.append(this.innerContent.render().el);        
        return this;
    }
});

AWP.View.ApprovalTabDialog = AWP.View.ApprovalTab.extend({
    className: "noborder awp-container",
    
    initialize: function (options) {
        options = _.extend(options, {
            innerContent: new AWP.View.ApprovalDialog({
                model: this.model,
                buttons: this.setActions(this.model),
                addnote: true,
                disableNote: this._setOptionalNotes(),
                note: ''
            })
        });
        this.config(options);
    },
    
    setActions: function (approval) {
        var buttons = {};
        if(approval.get("canApprove")) {
            buttons.approve = {"primary": true};
        }
        else {
            buttons.approve = {"primary": false, "readonly": true};
        }
        if(approval.get("canReject")) {
            buttons.reject = {"primary": false};
        }
        else {
            buttons.reject = {"primary": false, "readonly": true};
        }
        
        return buttons;
    },

    /**
     * Optional notes are disabled when approving are disabled
     * If approve and/or reject is enabled, then we allow adding notes
     * @since 1.2
     */
    _setOptionalNotes: function () {
        var disableNote = true;

        if(this.model.get('canApprove') || this.model.get('canReject')) {
            disableNote = false;
        }

        return disableNote;
    }
});

AWP.View.ApprovalTabApprovers = AWP.View.ApprovalTab.extend({
    
    initialize: function (options) {
        options = _.extend(options, {
            innerContent: new AWP.View.List({
                model : this.model.get('approvers')
            })
        });
        this.config(options);
        
        // assign button
        if(this.model.get('canAssign')) {
            this.$el.prepend(AWP.Templates.assignBtn());
            this.$('.assignMoreApproval input').on('click', _.bind(this.assignApproval, this));
        }

        if(this.model.get('minimumRequiredApprovers') && this.model.get('minimumRequiredApprovers') > 0 && this.model.get('minimumRequiredApprovers') > this.model.get('approvers').length) {
            var div = AJS.$('<span></span>')
            .addClass('awp-lozenge-info awp-lozenge-list aui-lozenge aui-lozenge-subtle')
            .html(AJS.I18n.getText("adhocworkflows.tab.approvals", [this.model.get('minimumRequiredApprovers')]));
            this.$el.prepend(div);
        }
    },
    
    assignApproval: function(event) {
        event.preventDefault();
        
        // other slides
        var assignSlide = new AWP.View.AssignSlide({
            // slide prop
            model: this.model,
            hidden: true,
            caption: this.model.get("name")
        });
        assignSlide.render();
        assignSlide.show();
    }
});


AWP.View.ApprovalTabApprovals = AWP.View.ApprovalTab.extend({
    initialize: function (options) {
        options = _.extend(options, {
            caption: AJS.I18n.getText('adhocworkflows.tab.approvals'),
            innerContent: new AWP.View.ApprovalList({
                model : this.model
            })
        });
        this.config(options);
    }
});


AWP.View.ApprovalTabState = AWP.View.ApprovalTab.extend({
    id: "select-state",
    className: "noborder awp-container",
    
    initialize: function (options) {
        options = _.extend(options, {
            caption : AJS.I18n.getText("adhocworkflows.tab.selectstate"),
            innerContent: new AWP.View.StateDialog({
                model : this.model,
                
                buttons: this.setActions(this.model),
                addnote: true,
                note: ''
            })
        });
        this.config(options);
    },
    
    setActions: function (approval) {
        var buttons = {};
        buttons.accept = {"primary": true};
        
        return buttons;
    }
});