/*
 * Copyright (c) 2022 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

var AWP = AWP || {};
AWP.ProgressTracker = (function(states, current, stateDescription) {
    var maxStates = 5,          // max number of states displayed
        rendered = false,       // html tracker is rendered
        hintHiddenStates = '',  // alt text at '...' dots
        className = 'awp-progress-tracker', // main class name
        template = AWP.Templates.progresstracker;

    initialize = function () {
        filterStates();

        if(!stateDescription) {
            stateDescription = '';
        }
    };

    /*
     * Checks if current state exists in the states array
     * Optional param for current state
     */
    checkStates = function () {
        var exist = false;

        // optional param = current state
        if(arguments.length > 0) {
            current = arguments[0];
        }
        // native indexOf is not supported at IE<9
        var i = states.indexOf(current);
        if(i >= 0) {
            exist = true;
        }

        return exist;
    };

    /*
     * If there are more than maxStates, it will be filtered and shortened
     * The algorythm will display the current state and the next nearests, and the last
     */
    filterStates = function () {
        var numStates = states.length;

        this.hintHiddenStates = '';

        if(numStates > maxStates) {
            var boundary  = numStates - maxStates;
            
            var i = 0,
                found = false;

            while(i < numStates && !found) {
                if(states[i] == current) {
                    found = true;
                }
                i++;
            }
            i--;

            // first state
            if(i  == 0) {
                for(j = 0; j < maxStates-2; j++) {
                    states[j] = states[i + j];
                }
                states[j] = "...";
                states[j+1] = states[numStates - 1];

                states.splice(maxStates);
                hiddenStates = numStates - (i+(maxStates-1));
                
                hintHiddenStates = "+" + hiddenStates + " states";
            }
            // intermediate state but far from the last
            else if(i < boundary) {
                for(j = 0; j < maxStates-2; j++) {
                    states[j] = states[i + j];
                }
                states[j] = "...";
                states[j+1] = states[numStates - 1];

                states.splice(maxStates);
                hiddenStates = numStates - (i+(maxStates-1));

                hintHiddenStates = "+" + hiddenStates + " states";
            }
            // close to the last state already
            else {
                states.splice(0, boundary);
                states.unshift("...");
            }   
        }
    };

    render = function () {
        var html = '';

        // states
        html = template({
            el: className,
            states: states,
            current: current,
            hintHiddenStates: hintHiddenStates,
            stateDescription: stateDescription
        });
        rendered = true;
        
        return html;
    };

    isRendered = function () {
        return rendered;
    };

    $el = function () {
        return AJS.$('.' + className);
    };

    initialize();

    return {
        $el: $el,

        checkStates: checkStates,
        isRendered: isRendered,
        render: render
    }
});