/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowreports.model;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.core.VersionHistorySummary;
import com.atlassian.confluence.user.ConfluenceUser;
import com.comalatech.confluence.states.model.Activity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ModificationActivity
extends Activity {
    boolean creation;
    int version;
    List<ConfluenceUser> contributors;

    public ModificationActivity(VersionHistorySummary summary, List<ConfluenceUser> contributors) {
        super(summary.getLastModifierName(), summary.getLastModificationDate());
        this.creation = summary.getVersion() == 1;
        this.version = summary.getVersion();
        this.contributors = contributors;
        this.setComment(summary.getVersionComment());
    }

    public boolean isCreation() {
        return this.creation;
    }

    public int getVersion() {
        return this.version;
    }

    public List<ConfluenceUser> getContributors() {
        return this.contributors;
    }

    public List<String> getContributorsUsernames() {
        ArrayList<String> contributorsNames = new ArrayList<String>();
        if (this.contributors != null) {
            for (ConfluenceUser confluenceUser : this.contributors) {
                if (confluenceUser == null) {
                    contributorsNames.add(ConfluenceActionSupport.getTextStatic((String)"com.comalatech.activity.report.csvexport.anonymous"));
                    continue;
                }
                contributorsNames.add(confluenceUser.getName());
            }
        }
        return contributorsNames;
    }

    @Override
    public Map<String, String> getAttributes() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("version", "" + this.version);
        return map;
    }

    @Override
    public String getActivityKey() {
        return "modification";
    }

    @Override
    public String getActivityId() {
        return "";
    }
}

