/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.tasks;

import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.comalatech.confluence.workflow.activeobjects.accessor.QueuedJobEntityAccessor;
import com.comalatech.confluence.workflow.activeobjects.entity.QueuedJobEntity;
import com.comalatech.confluence.workflow.tasks.manager.QueuedJobManager;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWorkflowsPersistentQueueJob
implements JobRunner {
    private static final Logger log = LoggerFactory.getLogger(AbstractWorkflowsPersistentQueueJob.class);
    private static final int QUEUED_JOBS_LIMIT = 100;
    private final QueuedJobManager queuedJobManager;
    private final TransactionTemplate transactionTemplate;
    private final QueuedJobEntityAccessor queuedJobEntityAccessor;

    public AbstractWorkflowsPersistentQueueJob(QueuedJobManager queuedJobManager, TransactionTemplate transactionTemplate, QueuedJobEntityAccessor queuedJobEntityAccessor) {
        this.queuedJobManager = queuedJobManager;
        this.transactionTemplate = transactionTemplate;
        this.queuedJobEntityAccessor = queuedJobEntityAccessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public JobRunnerResponse runJob(JobRunnerRequest request) {
        if (log.isDebugEnabled()) {
            log.debug("AbstractWorkflowsPersistentQueueJob starting");
        }
        String[] jobTypes = this.getJobTypes();
        if (log.isDebugEnabled()) {
            log.debug("Workflows queued jobs started for " + Arrays.asList(jobTypes));
        }
        try {
            List workflowActionEntities = (List)this.transactionTemplate.execute(() -> this.queuedJobEntityAccessor.findAll(jobTypes, 100));
            for (QueuedJobEntity entity : workflowActionEntities) {
                try {
                    if (request.isCancellationRequested()) {
                        JobRunnerResponse jobRunnerResponse = JobRunnerResponse.aborted((String)"Job cancelled.");
                        return jobRunnerResponse;
                    }
                    this.transactionTemplate.execute(() -> {
                        this.queuedJobManager.executeQueuedJob(entity);
                        return null;
                    });
                }
                catch (Exception ex) {
                    log.error(ex.getMessage(), (Throwable)ex);
                    JobRunnerResponse jobRunnerResponse = JobRunnerResponse.failed((String)"Job failed.");
                    return jobRunnerResponse;
                }
                finally {
                    this.transactionTemplate.execute(() -> {
                        this.queuedJobEntityAccessor.delete(entity);
                        return null;
                    });
                }
            }
            if (log.isDebugEnabled()) {
                log.debug("Workflows queued jobs finished for " + Arrays.asList(jobTypes));
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return JobRunnerResponse.failed((String)"Job failed.");
        }
        return JobRunnerResponse.success((String)"Job finished successfully.");
    }

    protected abstract String[] getJobTypes();
}

