/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.supportconsole.mappers;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.JsonContentProperty;
import com.atlassian.confluence.api.service.content.ContentPropertyService;
import com.atlassian.confluence.pages.AbstractPage;
import com.comalatech.confluence.dataextractor.JsonContentPropertiesKeys;
import com.comalatech.confluence.workflow.supportconsole.mappers.contract.SupportConsoleReportDataPopulator;
import com.comalatech.confluence.workflow.supportconsole.model.PageJsonContentPropertiesListData;
import java.util.ArrayList;

public class PageJsonContentPropertiesDataPopulator
implements SupportConsoleReportDataPopulator<PageJsonContentPropertiesListData, AbstractPage> {
    private final ContentPropertyService contentPropertyService;

    public PageJsonContentPropertiesDataPopulator(ContentPropertyService contentPropertyService) {
        this.contentPropertyService = contentPropertyService;
    }

    @Override
    public PageJsonContentPropertiesListData populateForTarget(AbstractPage target) {
        ArrayList<PageJsonContentPropertiesListData.ContentProperty> pageContentProperties = new ArrayList<PageJsonContentPropertiesListData.ContentProperty>();
        for (String s : JsonContentPropertiesKeys.getAllJsonCPs()) {
            JsonContentProperty jsonContentProperty = (JsonContentProperty)this.contentPropertyService.find(new Expansion[0]).withContentId(target.getContentId()).withPropertyKey(s).fetchOrNull();
            if (jsonContentProperty == null) continue;
            PageJsonContentPropertiesListData.ContentProperty contentProperty = new PageJsonContentPropertiesListData.ContentProperty(jsonContentProperty.getKey(), jsonContentProperty.getValue().toString());
            pageContentProperties.add(contentProperty);
        }
        return new PageJsonContentPropertiesListData(pageContentProperties);
    }
}

