/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.rest.resources;

import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.atlassian.user.User;
import com.comalatech.confluence.adhoc.dao.AdhocWorkflowDao;
import com.comalatech.confluence.adhocworkflows.rest.permissions.WorkflowsAppRequired;
import com.comalatech.confluence.adhocworkflows.rest.permissions.WorkflowsLiteAppRequired;
import com.comalatech.confluence.license.WorkflowsFeatureManager;
import com.comalatech.confluence.workflow.Workflow;
import com.comalatech.confluence.workflow.rest.model.PermissionRequired;
import com.comalatech.confluence.workflow.rest.model.RestWorkflow;
import com.comalatech.workflow.template.WorkflowTemplateManager;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.opensymphony.util.TextUtils;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;

public abstract class AbstractAdminRestResource {
    private static final Logger log = LoggerFactory.getLogger(AbstractAdminRestResource.class);
    protected final PermissionManager permissionManager;
    protected final SpaceManager spaceManager;
    protected final WorkflowTemplateManager workflowTemplateManager;
    protected final AdhocWorkflowDao adhocWorkflowDao;
    protected final WorkflowsFeatureManager workflowsFeatureManager;
    protected final PageManager pageManager;
    public static final String UPDATE_PARAM_NAME = "name";
    public static final String UPDATE_PARAM_LABEL = "label";
    public static final String UPDATE_PARAM_DESCRIPTION = "description";
    public static final String UPDATE_PARAM_MARKUP = "markup";
    private static final String APPLICATION_PERMISSION_ERROR = "The application has no permission over ";

    public AbstractAdminRestResource(PermissionManager permissionManager, SpaceManager spaceManager, @Qualifier(value="workflowTemplateManager") WorkflowTemplateManager workflowTemplateManager, AdhocWorkflowDao adhocWorkflowDao, WorkflowsFeatureManager workflowsFeatureManager, PageManager pageManager) {
        this.permissionManager = permissionManager;
        this.spaceManager = spaceManager;
        this.workflowTemplateManager = workflowTemplateManager;
        this.adhocWorkflowDao = adhocWorkflowDao;
        this.workflowsFeatureManager = workflowsFeatureManager;
        this.pageManager = pageManager;
    }

    protected RestWorkflow buildRestWorkflow(com.comalatech.workflow.model.Workflow workflow) {
        String workflowHandle = ((Workflow)workflow).getHandle();
        Workflow.WorkflowType workflowType = ((Workflow)workflow).getType();
        RestWorkflow restWorkflow = new RestWorkflow(workflow);
        restWorkflow.global = workflowType == Workflow.WorkflowType.LINKED_SPACE || workflowType == Workflow.WorkflowType.GLOBALE_TEMPLATE;
        restWorkflow.page = false;
        restWorkflow.handle = workflowHandle;
        if (TextUtils.stringSet((String)workflow.getErrorMessage())) {
            restWorkflow.errorMessage = workflow.getErrorMessage();
        }
        restWorkflow.markup = workflow.getWorkflowMarkup();
        return restWorkflow;
    }

    protected List<RestWorkflow> buildRestWorkflowList(List<com.comalatech.workflow.model.Workflow> workflows) {
        if (workflows == null) {
            return Collections.EMPTY_LIST;
        }
        return workflows.stream().map(w -> {
            String workflowHandle = ((Workflow)w).getHandle();
            Workflow.WorkflowType workflowType = ((Workflow)w).getType();
            RestWorkflow restWorkflow = new RestWorkflow((com.comalatech.workflow.model.Workflow)w);
            restWorkflow.global = workflowType == Workflow.WorkflowType.LINKED_SPACE || workflowType == Workflow.WorkflowType.GLOBALE_TEMPLATE;
            restWorkflow.page = false;
            restWorkflow.handle = workflowHandle;
            if (TextUtils.stringSet((String)w.getErrorMessage())) {
                String body;
                restWorkflow.markup = body = this.adhocWorkflowDao.getWorkflowTemplateBody(null, w.getName());
                restWorkflow.errorMessage = w.getErrorMessage();
            } else {
                restWorkflow.markup = w.getWorkflowMarkup();
            }
            return restWorkflow;
        }).collect(Collectors.toList());
    }

    protected String convertXHtmlToJson(String xHtml) {
        String errorStart = "<div class=\"error\">";
        String errorEnd = "</div>";
        if (StringUtils.contains((CharSequence)xHtml, (CharSequence)"<div class=\"error\">")) {
            String[] errorsInHtml = StringUtils.substringsBetween((String)xHtml, (String)"<div class=\"error\">", (String)"</div>");
            String errorTitle = StringUtils.substringBetween((String)xHtml, (String)"", (String)"<div class=\"error\">").replace("<br/>", "");
            JsonObject jsonResponse = new JsonObject();
            JsonArray errorList = new JsonArray();
            for (String error : errorsInHtml) {
                JsonObject jsonError = new JsonObject();
                jsonError.addProperty("type", "error");
                jsonError.addProperty("title", errorTitle);
                jsonError.addProperty("html", error);
                errorList.add((JsonElement)jsonError);
            }
            jsonResponse.add("messages", (JsonElement)errorList);
            return jsonResponse.toString();
        }
        return xHtml;
    }

    protected void moveReadAckMacroOutsideState(com.comalatech.workflow.model.Workflow workflow) {
        if (workflow instanceof Workflow) {
            ((Workflow)workflow).moveReadAckMacroOutOfState();
        }
    }

    protected Response handleException(Exception e) {
        log.error("Exception caught during mapping process", (Throwable)e);
        JSONObject error = new JSONObject();
        error.put("status", Response.Status.BAD_REQUEST.getStatusCode());
        error.put("message", StringEscapeUtils.escapeHtml4((String)e.getMessage()));
        if (e.getCause() != null) {
            error.put("cause", StringEscapeUtils.escapeHtml4((String)e.getCause().getMessage()));
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)error.toString()).type("application/json").build();
    }

    public abstract class RestCommand {
        private String spaceKey = null;

        public RestCommand() {
        }

        public RestCommand(String spaceKey) {
            this.spaceKey = spaceKey;
        }

        private RestCommand validate() throws ApplicationPermissionException {
            Method enclosingMethod = this.getClass().getEnclosingMethod();
            boolean allowed = true;
            boolean skip = false;
            if (null != this.getClass().getEnclosingClass().getAnnotation(WorkflowsAppRequired.class) || null != enclosingMethod.getAnnotation(WorkflowsAppRequired.class)) {
                skip = allowed = AbstractAdminRestResource.this.workflowsFeatureManager.isWorkflowsApp();
            }
            if (!(skip || null == this.getClass().getEnclosingClass().getAnnotation(WorkflowsLiteAppRequired.class) && null == enclosingMethod.getAnnotation(WorkflowsLiteAppRequired.class))) {
                allowed = AbstractAdminRestResource.this.workflowsFeatureManager.isWorkflowsLiteApp();
            }
            if (!allowed) {
                throw new ApplicationPermissionException(AbstractAdminRestResource.APPLICATION_PERMISSION_ERROR + this.getClass().getEnclosingClass().getName() + ":" + this.getClass().getEnclosingMethod().getName());
            }
            ConfluenceUser user = AuthenticatedUserThreadLocal.get();
            PermissionRequired annotation = enclosingMethod.getAnnotation(PermissionRequired.class);
            Object target = this.spaceKey != null ? AbstractAdminRestResource.this.spaceManager.getSpace(this.spaceKey) : this.getValidationTarget();
            for (String permission : annotation.value()) {
                if (AbstractAdminRestResource.this.permissionManager.hasPermission((User)user, Permission.forName((String)permission), target)) continue;
                throw new ApplicationPermissionException(user + "");
            }
            return this;
        }

        public Object getValidationTarget() {
            return PermissionManager.TARGET_APPLICATION;
        }

        public abstract Response doExecute();

        public Response execute() {
            try {
                return this.validate().doExecute();
            }
            catch (ApplicationPermissionException e) {
                if (e.getMessage().contains(AbstractAdminRestResource.APPLICATION_PERMISSION_ERROR)) {
                    return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)StringEscapeUtils.escapeHtml4((String)e.getMessage())).build();
                }
                return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)StringEscapeUtils.escapeHtml4((String)e.getMessage())).build();
            }
        }
    }

    public abstract class RestPageCommand
    extends RestCommand {
        private long contentId;

        public RestPageCommand(long contentId) {
            this.contentId = contentId;
        }

        @Override
        public Object getValidationTarget() {
            return AbstractAdminRestResource.this.pageManager.getById(this.contentId);
        }
    }
}

