/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.rpc;

import com.atlassian.confluence.rpc.RemoteException;
import com.comalatech.confluence.credentials.Credentials;
import com.comalatech.confluence.rpc.XmlRpcException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.xmlrpc.XmlRpcClient;
import org.apache.xmlrpc.XmlRpcClientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlRpcCommandManager {
    private static final Logger log = LoggerFactory.getLogger(XmlRpcCommandManager.class);
    protected Credentials credentials;
    private XmlRpcClient rpcClient;
    private String token;

    protected XmlRpcCommandManager(Credentials credentials) {
        this.credentials = credentials;
    }

    protected void loginAndCheckCredentials(boolean checkCreatePage) throws XmlRpcException {
        this.doRemotely(() -> {
            try {
                this.token = this.getLoginToken(this.credentials.getLoginUserName(), this.credentials.getPassword());
            }
            catch (XmlRpcClientException var2) {
                throw new XmlRpcException("Could not connect to " + this.credentials.getUrl() + ": " + var2.getMessage() + ", please check url");
            }
            catch (Exception var3) {
                throw new XmlRpcException("could not login as '" + this.credentials.getLoginUserName() + "' with the given password into " + this.credentials.getUrl() + ", please check username and password combination");
            }
            if (this.token == null) {
                throw new XmlRpcException("could not login as '" + this.credentials.getLoginUserName() + "' with the given password into " + this.credentials.getUrl() + ", please check username and password combination");
            }
            if (!this.isValidSpace(this.credentials.getRemoteSpaceKey())) {
                throw new XmlRpcException("space with key '" + this.credentials.getRemoteSpaceKey() + "' does not exist, or user not allowed to view the space");
            }
            if (checkCreatePage && !this.canCreatePages(this.credentials.getRemoteSpaceKey(), this.credentials.getLoginUserName())) {
                throw new XmlRpcException("user '" + this.credentials.getLoginUserName() + "' cannot create pages in space '" + this.credentials.getRemoteSpaceKey() + "'");
            }
            return null;
        });
    }

    protected void logout() throws RemoteException, XmlRpcException {
        this.doRemotely(new Action(){

            @Override
            public Object doInAction() throws Exception {
                XmlRpcCommandManager.this.call("confluence1.logout", new Object[0]);
                return null;
            }
        });
    }

    private boolean isValidSpace(String spaceKey) {
        try {
            this.call("confluence1.getSpace", new Object[]{spaceKey});
            return true;
        }
        catch (Exception var3) {
            return false;
        }
    }

    private boolean canCreatePages(String spaceKey, String userName) throws IOException, org.apache.xmlrpc.XmlRpcException {
        Vector permissions = (Vector)this.call("confluence1.getPermissionsForUser", new Object[]{spaceKey, userName});
        return permissions.contains("modify");
    }

    private String getLoginToken(String username, String password) throws IOException, org.apache.xmlrpc.XmlRpcException {
        return (String)this.call("confluence1.login", new Object[]{username, password});
    }

    protected Object call(String service, Object[] parameters) throws IOException, org.apache.xmlrpc.XmlRpcException {
        Vector params = this.makeParameters(this.token, parameters);
        if (log.isDebugEnabled()) {
            log.debug("token " + this.token + " " + service + this.makeDebugParams(service, parameters));
        }
        Object ret = null;
        try {
            ret = this.rpcClient.execute(service, params);
        }
        catch (org.apache.xmlrpc.XmlRpcException var6) {
            log.error(var6.getMessage());
            throw var6;
        }
        catch (IOException var7) {
            var7.printStackTrace();
        }
        if (ret instanceof org.apache.xmlrpc.XmlRpcException) {
            throw (org.apache.xmlrpc.XmlRpcException)((Object)ret);
        }
        return ret;
    }

    private List makeDebugParams(String service, Object[] parameters) {
        ArrayList<Object> params = new ArrayList<Object>();
        if ("confluence1.login".equals(service)) {
            if (parameters.length > 0) {
                params.add(parameters[0]);
            }
            return params;
        }
        for (Object parameter : parameters) {
            if (parameter instanceof Map) {
                params.add(this.obfuscateMap((Map)parameter));
                continue;
            }
            params.add(parameter);
        }
        return params;
    }

    private Map obfuscateMap(Map map) {
        if (map.get("content") != null) {
            HashMap newMap = new HashMap();
            newMap.putAll(map);
            newMap.put("content", "<HIDDEN FOR DEBUGGING>");
            map = newMap;
        }
        return map;
    }

    private Vector makeParameters(String token, Object[] parameters) {
        Vector<String> params = new Vector<String>();
        if (token != null) {
            params.add(token);
        }
        Collections.addAll(params, parameters);
        return params;
    }

    protected Object doRemotely(Action action) throws XmlRpcException {
        Object var2;
        try {
            if (this.rpcClient == null) {
                this.rpcClient = new XmlRpcClient(this.credentials.getUrl());
            }
            var2 = action.doInAction();
        }
        catch (org.apache.xmlrpc.XmlRpcException var7) {
            throw new XmlRpcException(var7.getLocalizedMessage(), var7);
        }
        catch (Exception var8) {
            log.error(var8.getMessage());
            throw new XmlRpcException(var8.getMessage(), var8);
        }
        return var2;
    }

    protected static interface Action {
        public Object doInAction() throws Exception;
    }
}

