/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.dataextractor.job;

import com.atlassian.core.task.DefaultTaskQueue;
import com.atlassian.core.task.MultiQueueTaskManager;
import com.atlassian.core.task.TaskQueue;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentPropertyPersistenceJob
implements JobRunner {
    private static final Logger log = LoggerFactory.getLogger(ContentPropertyPersistenceJob.class);
    private MultiQueueTaskManager multiQueueTaskManager;
    public static final String QUEUE_NAME = "content_queue";

    public ContentPropertyPersistenceJob(MultiQueueTaskManager multiQueueTaskManager) {
        this.multiQueueTaskManager = multiQueueTaskManager;
    }

    public JobRunnerResponse runJob(JobRunnerRequest request) {
        if (log.isDebugEnabled()) {
            log.debug("ContentPropertyPersistenceJob starting");
        }
        try {
            TaskQueue queue = this.multiQueueTaskManager.getTaskQueue(QUEUE_NAME);
            if (queue == null) {
                queue = new DefaultTaskQueue();
                this.multiQueueTaskManager.addTaskQueue(QUEUE_NAME, queue);
            }
            if (queue.isFlushing()) {
                log.debug("Task queue {} was already being flushed - skipped this time", (Object)queue);
                return JobRunnerResponse.aborted((String)("Task queue " + queue + " was already being flushed"));
            }
            log.debug("Executing tasks for queue {}, queue size {}", (Object)queue, (Object)queue.size());
            queue.flush();
            log.debug("ContentPropertyPersistenceJob finished! ");
            return JobRunnerResponse.success((String)("Executed tasks for queue " + queue));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return JobRunnerResponse.failed((String)"Job failed.");
        }
    }
}

