/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.contributors;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.user.UserKey;
import com.comalatech.confluence.contributors.ContributorsManager;
import com.comalatech.confluence.dataextractor.ComalaPropertiesSetManager;
import com.comalatech.confluence.dataextractor.DefaultComalaPropertiesSetManager;
import com.opensymphony.util.TextUtils;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContributorsManagerImpl
implements ContributorsManager {
    private static final Logger log = LoggerFactory.getLogger(ContributorsManagerImpl.class);
    private static final int MAX_SIZE = 15;
    private static final String CONTRIBUTORS_CONTENT_PROPERTY_KEY = "com.comalatech.workflows.contributors";
    protected final UserAccessor userAccessor;
    private final ComalaPropertiesSetManager contentPropertyManager;
    private final ApplicationProperties applicationProperties;
    private static final int CONFLUENCE_7_4_5_MARKETPLACE_BUILD_NUMBER = 11921;
    private static final int CONFLUENCE_7_4_6_MARKETPLACE_BUILD_NUMBER = 11923;
    private static final int CONFLUENCE_7_4_14_MARKETPLACE_BUILD_NUMBER = 11948;
    private static final int CONFLUENCE_7_5_0_MARKETPLACE_BUILD_NUMBER = 12447;
    private static final int CONFLUENCE_7_8_0_MARKETPLACE_BUILD_NUMBER = 13337;

    public ContributorsManagerImpl(UserAccessor userAccessor, ComalaPropertiesSetManager contentPropertyManager, ApplicationProperties applicationProperties) {
        this.userAccessor = userAccessor;
        this.contentPropertyManager = contentPropertyManager;
        this.applicationProperties = applicationProperties;
    }

    @Override
    public void addContributor(AbstractPage page, String user) {
        ConfluenceUser confluenceUser = this.userAccessor.getUserByName(user);
        if (confluenceUser == null) {
            return;
        }
        List<String> contributorsKeys = this.getContributorsProperty(page);
        String key = confluenceUser.getKey().toString();
        contributorsKeys.remove(key);
        contributorsKeys.add(key);
        if (contributorsKeys.size() > 15) {
            contributorsKeys = contributorsKeys.subList(0, 14);
        }
        this.setContributorsProperty(page, contributorsKeys);
    }

    @Override
    public String getContributors(AbstractPage page) {
        List<String> contributorsKeys = this.getContributorsProperty(page);
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        String key = user.getKey().toString();
        contributorsKeys.remove(key);
        return String.join((CharSequence)",", this.getUserNamesFromUserKeysAsString(contributorsKeys));
    }

    private List<String> getUserNamesFromUserKeysAsString(List<String> userKeys) {
        return userKeys.stream().map(userKey -> this.userAccessor.getExistingUserByKey(new UserKey(userKey))).filter(Objects::nonNull).map(Principal::getName).collect(Collectors.toList());
    }

    @Override
    public void deleteContributors(AbstractPage page) {
        this.contentPropertyManager.removeProperty((ContentEntityObject)page, CONTRIBUTORS_CONTENT_PROPERTY_KEY);
    }

    private List<String> getContributorsProperty(AbstractPage page) {
        String contributorsKeys;
        String buildNumber;
        Integer type = this.contentPropertyManager.getTypeProperty((ContentEntityObject)page, CONTRIBUTORS_CONTENT_PROPERTY_KEY);
        if (type != null && type.equals(DefaultComalaPropertiesSetManager.STRING_VAL_TYPE) && (buildNumber = this.applicationProperties.getBuildNumber()) != null) {
            try {
                int marketplaceBuildNumber = Integer.parseInt(buildNumber);
                if ((marketplaceBuildNumber <= 11921 || marketplaceBuildNumber >= 12447) && marketplaceBuildNumber < 13337) {
                    String oldContributors = this.contentPropertyManager.getStringProperty((ContentEntityObject)page, CONTRIBUTORS_CONTENT_PROPERTY_KEY);
                    this.contentPropertyManager.removeProperty((ContentEntityObject)page, CONTRIBUTORS_CONTENT_PROPERTY_KEY);
                    this.contentPropertyManager.setTextProperty((ContentEntityObject)page, CONTRIBUTORS_CONTENT_PROPERTY_KEY, oldContributors);
                }
            }
            catch (Exception ex) {
                log.error("Error converting old type of contributors content property: " + ex.getMessage());
            }
        }
        if (!TextUtils.stringSet((String)(contributorsKeys = this.contentPropertyManager.getTextProperty((ContentEntityObject)page, CONTRIBUTORS_CONTENT_PROPERTY_KEY)))) {
            return new ArrayList<String>();
        }
        return Arrays.stream(contributorsKeys.split(",")).collect(Collectors.toList());
    }

    private void setContributorsProperty(AbstractPage page, List<String> list) {
        this.contentPropertyManager.setTextProperty((ContentEntityObject)page, CONTRIBUTORS_CONTENT_PROPERTY_KEY, String.join((CharSequence)",", list));
    }
}

