/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowreports.pageactivity;

import com.atlassian.sal.api.message.I18nResolver;
import com.comalatech.confluence.workflowreports.pageactivity.PageActivityCsvConfig;
import com.comalatech.confluence.workflowreports.pageactivity.PageActivityEntryProcessor;
import java.io.Serializable;

public abstract class PageActivityCsvProcessor
implements PageActivityEntryProcessor {
    protected static final String LINE_SEPARATOR = System.getProperty("line.separator");
    protected static final String COMMA = ",";
    private PageActivityCsvConfig pageActivityCsvConfig;
    private final I18nResolver i18nResolver;

    public PageActivityCsvProcessor(I18nResolver i18nResolver) {
        this.i18nResolver = i18nResolver;
    }

    protected void setPageActivityCsvConfig(PageActivityCsvConfig pageActivityCsvConfig) {
        this.pageActivityCsvConfig = pageActivityCsvConfig;
    }

    protected String getTextStatic(String key) {
        if (this.pageActivityCsvConfig.getLocale() == null) {
            return this.i18nResolver.getText(key);
        }
        return this.i18nResolver.getText(this.pageActivityCsvConfig.getLocale(), key);
    }

    protected String getTextStatic(String key, String[] args) {
        if (this.pageActivityCsvConfig.getLocale() == null) {
            return this.i18nResolver.getText(key, (Serializable[])args);
        }
        return this.i18nResolver.getText(this.pageActivityCsvConfig.getLocale(), key, (Serializable[])args);
    }

    protected boolean isSkipOtherVersion() {
        return this.pageActivityCsvConfig.isSkipOtherVersion();
    }

    protected void generateHeaders(StringBuilder builder) {
        builder.append(this.getTextStatic("com.comalatech.activity.report.csvexport.date.header")).append(COMMA).append(this.getTextStatic("com.comalatech.activity.report.csvexport.username.header")).append(COMMA);
        builder.append(this.getTextStatic("com.comalatech.activity.report.csvexport.contributors.header")).append(COMMA);
        builder.append(this.getTextStatic("com.comalatech.activity.report.csvexport.activity.header")).append(COMMA).append(this.getTextStatic("com.comalatech.activity.report.csvexport.description.header")).append(COMMA).append(this.getTextStatic("com.comalatech.activity.report.csvexport.pageversion.header")).append(COMMA).append(this.getTextStatic("com.comalatech.activity.report.csvexport.pageId.header")).append(COMMA).append(this.getTextStatic("com.comalatech.activity.report.csvexport.usercomment.header")).append(LINE_SEPARATOR);
    }
}

