/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.model;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.user.ConfluenceUser;
import com.comalatech.confluence.timers.TimerUtils;
import com.comalatech.confluence.workflow.ValueStore;
import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflow.model.Condition;
import com.comalatech.confluence.workflow.model.ValueReference;
import com.comalatech.confluence.workflowcontainer.model.SerializableMacro;
import java.util.Date;

public class MetadataCondition
extends Condition {
    private String referredValue;
    private String comparedValue;
    boolean greaterThan;
    boolean lessThan;
    boolean supplierReference;

    public MetadataCondition(boolean not, String referredValue, String comparedValue) {
        super(not);
        this.referredValue = referredValue;
        if (comparedValue.startsWith("<")) {
            this.lessThan = true;
            this.comparedValue = comparedValue.substring(1);
        } else if (comparedValue.startsWith(">")) {
            this.greaterThan = true;
            this.comparedValue = comparedValue.substring(1);
        } else {
            this.comparedValue = comparedValue;
        }
        this.supplierReference = comparedValue.indexOf(":") >= 0;
    }

    public MetadataCondition(boolean not, String referredValue, String rawComparedValue, boolean greaterThan, boolean lessThan, boolean supplierReference) {
        super(not);
        this.referredValue = referredValue;
        this.comparedValue = rawComparedValue;
        this.greaterThan = greaterThan;
        this.lessThan = lessThan;
        this.supplierReference = supplierReference;
    }

    public String getReferredValue() {
        return this.referredValue;
    }

    public String getComparedValue() {
        return this.comparedValue;
    }

    public boolean isGreaterThan() {
        return this.greaterThan;
    }

    public boolean isLessThan() {
        return this.lessThan;
    }

    public boolean isSupplierReference() {
        return this.supplierReference;
    }

    @Override
    protected boolean evaluateBinary(ValueStore valueStore) throws WorkflowException {
        String refValue;
        String compValue = valueStore.getValue(this.comparedValue);
        if (this.supplierReference) {
            Object value = MetadataCondition.getWorkflowParameterManager().getSupplierValue(valueStore.getPage(), this.referredValue);
            if (value == null) {
                refValue = valueStore.getValue(this.referredValue);
            } else {
                if (value instanceof Date) {
                    Date dateValue = (Date)value;
                    Date compDate = TimerUtils.parseDateMultipleFormats(compValue);
                    if (compDate == null) {
                        return false;
                    }
                    if (this.greaterThan) {
                        return dateValue.getTime() > compDate.getTime();
                    }
                    if (this.lessThan) {
                        return dateValue.getTime() < compDate.getTime();
                    }
                    return dateValue.equals(compDate);
                }
                if (value instanceof Integer) {
                    int compInt;
                    Integer intValue = (Integer)value;
                    try {
                        compInt = Integer.parseInt(compValue);
                    }
                    catch (Exception e) {
                        return false;
                    }
                    if (this.greaterThan) {
                        return intValue > compInt;
                    }
                    if (this.lessThan) {
                        return intValue < compInt;
                    }
                    return intValue == compInt;
                }
                refValue = value instanceof AbstractPage ? ((AbstractPage)value).getTitle() : (value instanceof ConfluenceUser ? ((ConfluenceUser)value).getName() : value.toString());
            }
        } else {
            refValue = valueStore.getValue(this.referredValue);
        }
        if (this.greaterThan) {
            return refValue.compareTo(compValue) > 0;
        }
        if (this.lessThan) {
            return refValue.compareTo(compValue) < 0;
        }
        return refValue.equals(compValue);
    }

    @Override
    public void addMacroParameters(SerializableMacro macro) {
        macro.addParameter(this.referredValue, (Object)((this.not ? "!" : "") + (this.greaterThan ? ">" : (this.lessThan ? "<" : "")) + this.comparedValue));
    }

    @Override
    public String toString(ValueStore valueStore) {
        StringBuffer sb = new StringBuffer(ValueReference.referenceToString(this.referredValue, valueStore)).append(" is ");
        if (this.not) {
            sb.append("not ");
        }
        if (this.greaterThan) {
            sb.append("greater than ");
        } else if (this.lessThan) {
            sb.append("less than ");
        } else {
            sb.append("equals to ");
        }
        sb.append(ValueReference.referenceToString(this.comparedValue, valueStore));
        return sb.toString();
    }

    public String toString() {
        return this.toString(null);
    }
}

