/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.analytics.usecases.eventsusage.listener;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.comalatech.confluence.states.event.BlogPostTaskAssignEvent;
import com.comalatech.confluence.states.event.BlogPostTaskCompleteEvent;
import com.comalatech.confluence.states.event.BlogPostTaskCreateEvent;
import com.comalatech.confluence.states.event.BlogPostTaskDeletedEvent;
import com.comalatech.confluence.states.event.BlogPostTaskUpdatedEvent;
import com.comalatech.confluence.states.event.DefaultTaskDueDateExpiredEvent;
import com.comalatech.confluence.states.event.PageTaskAssignEvent;
import com.comalatech.confluence.states.event.PageTaskCompleteEvent;
import com.comalatech.confluence.states.event.PageTaskCreateEvent;
import com.comalatech.confluence.states.event.PageTaskDeletedEvent;
import com.comalatech.confluence.states.event.PageTaskUpdatedEvent;
import com.comalatech.confluence.util.WorkflowsListener;
import com.comalatech.confluence.workflow.analytics.usecases.eventsusage.contracts.EventCounterManager;
import org.springframework.beans.factory.annotation.Qualifier;

public class TaskEventsAnalyticsListener
extends WorkflowsListener {
    private final EventCounterManager taskEventCounterUseCase;
    private final EventCounterManager totalEventCounterUseCase;

    public TaskEventsAnalyticsListener(EventPublisher eventPublisher, @Qualifier(value="taskEventCounterUseCase") EventCounterManager taskEventCounterUseCase, @Qualifier(value="totalEventCounterUseCase") EventCounterManager totalEventCounterUseCase) {
        super(eventPublisher);
        this.taskEventCounterUseCase = taskEventCounterUseCase;
        this.totalEventCounterUseCase = totalEventCounterUseCase;
    }

    @EventListener
    public void onPageTaskCreateEvent(PageTaskCreateEvent event) {
        this.incrementCounters();
    }

    @EventListener
    public void onBlogPostTaskCreateEvent(BlogPostTaskCreateEvent event) {
        this.incrementCounters();
    }

    @EventListener
    public void onPageTaskCompleteEvent(PageTaskCompleteEvent event) {
        this.incrementCounters();
    }

    @EventListener
    public void onBlogPostTaskCompleteEvent(BlogPostTaskCompleteEvent event) {
        this.incrementCounters();
    }

    @EventListener
    public void onBlogPostTaskDeletedEvent(BlogPostTaskDeletedEvent event) {
        this.incrementCounters();
    }

    @EventListener
    public void onPageTaskDeletedEvent(PageTaskDeletedEvent event) {
        this.incrementCounters();
    }

    @EventListener
    public void onBlogPostTaskAssignEvent(BlogPostTaskAssignEvent event) {
        this.incrementCounters();
    }

    @EventListener
    public void onPageTaskAssignEvent(PageTaskAssignEvent event) {
        this.incrementCounters();
    }

    @EventListener
    public void onDefaultTaskDueDateExpiredEvent(DefaultTaskDueDateExpiredEvent event) {
        this.incrementCounters();
    }

    @EventListener
    public void onPageTaskUpdatedEvent(PageTaskUpdatedEvent event) {
        this.incrementCounters();
    }

    @EventListener
    public void onBlogPostTaskUpdatedEvent(BlogPostTaskUpdatedEvent event) {
        this.incrementCounters();
    }

    private void incrementCounters() {
        this.totalEventCounterUseCase.increment();
        this.taskEventCounterUseCase.increment();
    }
}

