/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow;

import com.atlassian.bonnie.Searchable;
import com.atlassian.confluence.compat.struts2.actioncontext.ActionContextCompatManager;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.search.ConfluenceIndexer;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.user.Entity;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import com.atlassian.user.User;
import com.comalatech.confluence.messaging.Message;
import com.comalatech.confluence.messaging.PageMessageManager;
import com.comalatech.confluence.states.StateAccessor;
import com.comalatech.confluence.states.StateManager;
import com.comalatech.confluence.states.model.DueDateRecord;
import com.comalatech.confluence.states.model.PageState;
import com.comalatech.confluence.states.model.State;
import com.comalatech.confluence.tasks.model.PageTasks;
import com.comalatech.confluence.workflow.ApprovalAccessor;
import com.comalatech.confluence.workflow.ApprovalCheckDecorator;
import com.comalatech.confluence.workflow.ApprovalManager;
import com.comalatech.confluence.workflow.DefaultValueStore;
import com.comalatech.confluence.workflow.InternalWorkflowParameterManager;
import com.comalatech.confluence.workflow.PageWorkflows;
import com.comalatech.confluence.workflow.SelectorManager;
import com.comalatech.confluence.workflow.UsersListResolver;
import com.comalatech.confluence.workflow.ValueStore;
import com.comalatech.confluence.workflow.WorkflowAccessor;
import com.comalatech.confluence.workflow.WorkflowActionManager;
import com.comalatech.confluence.workflow.WorkflowConfigurationManager;
import com.comalatech.confluence.workflow.WorkflowCustomMessageException;
import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflow.WorkflowUserException;
import com.comalatech.confluence.workflow.esignatures.configuration.ESignaturesConfigurationManager;
import com.comalatech.confluence.workflow.esignatures.model.ESignatureCredentials;
import com.comalatech.confluence.workflow.events.BlogPostApprovalApproveEvent;
import com.comalatech.confluence.workflow.events.BlogPostApprovalAssignedEvent;
import com.comalatech.confluence.workflow.events.BlogPostApprovalRejectEvent;
import com.comalatech.confluence.workflow.events.DefaultApprovalUnassignedEvent;
import com.comalatech.confluence.workflow.events.PageApprovalApproveEvent;
import com.comalatech.confluence.workflow.events.PageApprovalAssignedEvent;
import com.comalatech.confluence.workflow.events.PageApprovalRejectEvent;
import com.comalatech.confluence.workflow.model.Approval;
import com.comalatech.confluence.workflow.model.ApprovalCheck;
import com.comalatech.confluence.workflow.model.ApprovalStatus;
import com.comalatech.confluence.workflow.model.Approver;
import com.comalatech.confluence.workflow.model.DecoratedApprovalCheck;
import com.comalatech.confluence.workflow.model.Selector;
import com.comalatech.confluence.workflow.rest.model.Message;
import com.comalatech.confluence.workflowcontainer.model.RequireApprovalComment;
import com.comalatech.workflow.model.Selectable;
import com.comalatech.workflow.model.SignatureType;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;

public class DefaultApprovalManager
implements ApprovalManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultApprovalManager.class);
    private static final String DELETED_USER_WARNING_MESSAGE = "workflows.deleted.user.warning.message";
    private static final String DELETED_USER_WARNING_DESC = "workflows.deleted.user.warning.desc";
    private final WorkflowAccessor workflowAccessor;
    private final EventPublisher eventPublisher;
    private final GroupManager groupManager;
    private final ConfluenceIndexer indexer;
    private final AttachmentManager attachmentManager;
    private final ApprovalCheckDecorator approvalCheckDecorator;
    private final SelectorManager selectorManager;
    private final ApprovalAccessor approvalAccessor;
    private final StateAccessor stateAccessor;
    private final StateManager stateManager;
    private final PageMessageManager pageMessageManager;
    private final WorkflowActionManager workflowActionManager;
    private final WorkflowConfigurationManager workflowConfigurationManager;
    private final UsersListResolver usersListResolver;
    private final InternalWorkflowParameterManager workflowParameterManager;
    private final ESignaturesConfigurationManager eSignaturesConfigurationManager;
    private final ActionContextCompatManager actionContextCompatManager;

    public DefaultApprovalManager(WorkflowAccessor workflowAccessor, EventPublisher eventPublisher, GroupManager groupManager, ConfluenceIndexer indexer, AttachmentManager attachmentManager, ApprovalCheckDecorator approvalCheckDecorator, SelectorManager selectorManager, ApprovalAccessor approvalAccessor, StateAccessor stateAccessor, StateManager stateManager, PageMessageManager pageMessageManager, WorkflowActionManager workflowActionManager, WorkflowConfigurationManager workflowConfigurationManager, UsersListResolver usersListResolver, InternalWorkflowParameterManager workflowParameterManager, ESignaturesConfigurationManager eSignaturesConfigurationManager, @Qualifier(value="actionContextCompatManager") ActionContextCompatManager actionContextCompatManager) {
        this.workflowAccessor = workflowAccessor;
        this.eventPublisher = eventPublisher;
        this.groupManager = groupManager;
        this.indexer = indexer;
        this.attachmentManager = attachmentManager;
        this.approvalCheckDecorator = approvalCheckDecorator;
        this.selectorManager = selectorManager;
        this.approvalAccessor = approvalAccessor;
        this.stateAccessor = stateAccessor;
        this.stateManager = stateManager;
        this.pageMessageManager = pageMessageManager;
        this.workflowActionManager = workflowActionManager;
        this.workflowConfigurationManager = workflowConfigurationManager;
        this.usersListResolver = usersListResolver;
        this.workflowParameterManager = workflowParameterManager;
        this.eSignaturesConfigurationManager = eSignaturesConfigurationManager;
        this.actionContextCompatManager = actionContextCompatManager;
        DecoratedApprovalCheck.setDecorator(approvalCheckDecorator);
        DecoratedApprovalCheck.setSelectorManager(selectorManager);
    }

    @Override
    public List<DecoratedApprovalCheck> getDecoratedApprovalChecks(PageWorkflows pageWorkflows, boolean checkApprovers, boolean isActionRequest) {
        List<Object> approvals;
        List<ApprovalCheck> checks;
        ValueStore valueStore = pageWorkflows.getValueStore();
        PageState pageState = valueStore.getPageState();
        this.getPageTasks(pageState);
        AbstractPage page = pageWorkflows.getPage();
        if (page.isLatestVersion()) {
            checks = this.approvalAccessor.getLatestApprovalChecks(page, pageState);
            approvals = pageWorkflows.getApprovals(pageState);
        } else {
            checks = this.approvalAccessor.getOldApprovalChecks(page, pageState);
            approvals = Collections.emptyList();
        }
        if (checkApprovers) {
            checks = this.checkApprovers(pageWorkflows, checks);
        }
        ArrayList<DecoratedApprovalCheck> decoratedChecks = new ArrayList<DecoratedApprovalCheck>();
        HashSet<String> approvalNames = new HashSet<String>();
        for (ApprovalCheck approvalCheck : checks) {
            if (pageWorkflows.getApproval(approvalCheck.getName()) == null) continue;
            approvalNames.add(approvalCheck.getName());
            try {
                DecoratedApprovalCheck decoratedCheck = new DecoratedApprovalCheck(valueStore, approvalCheck, pageWorkflows.getApproval(approvalCheck.getName()), false, this.isReleaseViewAction(isActionRequest), this.attachmentManager);
                decoratedChecks.add(decoratedCheck);
            }
            catch (WorkflowException e) {
                log.error("creating DecoratedApprovalCheck for " + approvalCheck.getName(), (Throwable)e);
                this.logMessage(page, approvalCheck.getName(), e.getMessage());
            }
        }
        for (Object approval1 : approvals) {
            Approval approval = (Approval)approval1;
            if (approvalNames.contains(approval.getName())) continue;
            try {
                DecoratedApprovalCheck decoratedCheck = new DecoratedApprovalCheck(valueStore, approval, this.attachmentManager);
                decoratedChecks.add(decoratedCheck);
            }
            catch (WorkflowUserException e) {
                log.error(e.getMessage() + " in page with id \"" + page.getId() + "\"");
                this.logMessage(page, approval.getName(), e.getMessage());
            }
            catch (WorkflowException e) {
                log.error(e.getMessage() + " in page with id \"" + page.getId() + "\"", (Throwable)e);
                this.logMessage(page, approval.getName(), e.getMessage());
            }
        }
        Collections.sort(decoratedChecks);
        if (log.isDebugEnabled()) {
            log.debug(checks.toString());
            log.debug(((Object)decoratedChecks).toString());
        }
        return decoratedChecks;
    }

    @Override
    public List<DecoratedApprovalCheck> getDecoratedApprovalChecks(PageWorkflows pageWorkflows, boolean checkApprovers) {
        return this.getDecoratedApprovalChecks(pageWorkflows, checkApprovers, true);
    }

    private List<ApprovalCheck> checkApprovers(PageWorkflows pageWorkflows, List<ApprovalCheck> checks) {
        ArrayList<ApprovalCheck> processed = new ArrayList<ApprovalCheck>();
        for (ApprovalCheck check : checks) {
            for (String approverName : check.getRequiredApprovers()) {
                List<ConfluenceUser> users = this.usersListResolver.getAsUsers(approverName);
                if (users.size() != 0) continue;
                String approvalName = check.getName();
                Object[] params = new String[]{approverName, approvalName};
                this.pageMessageManager.setMessage(pageWorkflows.getPage(), ConfluenceActionSupport.getTextStatic((String)DELETED_USER_WARNING_MESSAGE, (Object[])params), ConfluenceActionSupport.getTextStatic((String)DELETED_USER_WARNING_DESC), Message.MacroParamStyle.WARNING.param, 20L);
            }
            processed.add(check);
        }
        return processed;
    }

    private PageTasks getPageTasks(PageState state) {
        if (state == null) {
            return new PageTasks();
        }
        return state.getPageTasks();
    }

    private void logMessage(AbstractPage page, String approvalName, String message) {
        this.pageMessageManager.setMessage(page, "Workflow Error", AuthenticatedUserThreadLocal.get(), "Error in approval " + approvalName + ": " + message, Message.MacroParamStyle.WARNING.param, 20L);
    }

    private boolean isReleaseViewAction(boolean isActionRequest) {
        if (!isActionRequest) {
            return false;
        }
        return "releaseview".equals(this.actionContextCompatManager.getName());
    }

    @Override
    public void updateApprovalCheck(AbstractPage page, ApprovalCheck approvalCheck) throws WorkflowException {
        ApprovalCheck[] approvalChecks = this.approvalAccessor.getApprovalChecks(page);
        for (int i = 0; i < approvalChecks.length; ++i) {
            ApprovalCheck check = approvalChecks[i];
            if (check.getId() != approvalCheck.getId()) continue;
            approvalChecks[i] = approvalCheck;
            this.approvalAccessor.saveApprovalChecks(page, approvalChecks);
            return;
        }
        throw new WorkflowException("Could not find " + approvalCheck);
    }

    @Override
    public ApprovalCheck approvePage(AbstractPage page, String approvalName, boolean approved, String comment, ConfluenceUser user, boolean byPassUserCondition, boolean userCredentialChecked, boolean passwordCredentialChecked, boolean byPassCommentRequired) throws WorkflowException {
        Approval approval = null;
        PageWorkflows pageWorkflows = this.workflowAccessor.getWorkflows(page);
        if (pageWorkflows != null) {
            approval = pageWorkflows.getApproval(approvalName);
        }
        if (approval == null) {
            throw new WorkflowException(" approval " + approvalName + " does not exist");
        }
        return this.approvePage(page, approval, approved, comment, user, byPassUserCondition, userCredentialChecked, passwordCredentialChecked, byPassCommentRequired);
    }

    @Override
    public ApprovalCheck updateDueDate(AbstractPage page, PageWorkflows pageWorkflows, String approvalName, Date dueDate) throws WorkflowException {
        Approval approval = pageWorkflows.getApproval(approvalName);
        if (approval == null) {
            throw new WorkflowException("Invalid approval name: " + approvalName);
        }
        PageState pageState = pageWorkflows.getValueStore().getPageState();
        ApprovalCheck approvalCheck = this.approvalAccessor.getLatestApprovalCheck(page, pageState, approval.getName(), 0);
        if (approvalCheck != null) {
            if (dueDate != null) {
                if (approvalCheck.getCurrentDueDate() == null) {
                    approvalCheck.setCurrentDueDate(new DueDateRecord(dueDate, AuthenticatedUserThreadLocal.getUsername(), new Date()));
                } else if (approvalCheck.getCurrentDueDate().getDueDate() != dueDate) {
                    DueDateRecord currentDueDate = approvalCheck.getCurrentDueDate();
                    approvalCheck.addDueDateHistory(currentDueDate);
                    approvalCheck.setCurrentDueDate(new DueDateRecord(dueDate, AuthenticatedUserThreadLocal.getUsername(), new Date()));
                }
            } else if (approvalCheck.getCurrentDueDate() != null) {
                approvalCheck.addDueDateHistory(approvalCheck.getCurrentDueDate());
                approvalCheck.setCurrentDueDate(new DueDateRecord(null, AuthenticatedUserThreadLocal.getUsername(), new Date()));
            }
            this.updateApprovalCheck(page, approvalCheck);
        } else if (dueDate != null) {
            approvalCheck = new ApprovalCheck(approval.getName(), approval.getWeight(), page.getVersion(), this.attachmentManager.getLatestVersionsOfAttachments((ContentEntityObject)page), null);
            approvalCheck.setState(pageState);
            approvalCheck.setCurrentDueDate(new DueDateRecord(dueDate, AuthenticatedUserThreadLocal.getUsername(), new Date()));
            this.addApprovalCheck(page, approvalCheck);
        }
        this.indexer.reIndex((Searchable)page);
        return approvalCheck;
    }

    private void checkTransitionParamsBeforeApproval(AbstractPage page, PageWorkflows pageWorkflows, boolean approved) throws WorkflowException {
        State targetState;
        String targetStateName;
        State currentState = pageWorkflows.getStatesContainer().getState(this.stateAccessor.getStateName(page));
        if (currentState == null) {
            return;
        }
        String string = targetStateName = approved ? currentState.getApprovedStateName() : currentState.getRejectedStateName();
        if (targetStateName != null && (targetState = pageWorkflows.getState(targetStateName)) != null && !this.workflowParameterManager.isTransitionAllowed(page, targetState)) {
            throw new WorkflowCustomMessageException(Message.MessageType.ERROR, "Error", String.format("Cannot apply move to <%s> on page <%s> with pending required parameters", targetStateName, page.getIdAsString()), true, Message.MessageCode.INVALID_PARAMETERS);
        }
    }

    @Override
    public ApprovalCheck approvePage(AbstractPage page, Approval approval, boolean approved, String comment, ConfluenceUser user, boolean byPassUserCondition, boolean userCredentialChecked, boolean passwordCredentialChecked, boolean byPassCommentRequired) throws WorkflowException {
        return this.approvePage(page, approval, approved, comment, user, byPassUserCondition, userCredentialChecked, passwordCredentialChecked, byPassCommentRequired, false);
    }

    @Override
    public ApprovalCheck approvePage(AbstractPage page, Approval approval, boolean approved, String comment, ConfluenceUser user, boolean byPassUserCondition, boolean userCredentialChecked, boolean passwordCredentialChecked, boolean byPassCommentRequired, boolean skipApproveEvent) throws WorkflowException {
        ApprovalCheck approvalCheck;
        RequireApprovalComment requireApprovalComment;
        PageWorkflows pageWorkflows = this.workflowAccessor.getWorkflows(page);
        try {
            this.checkCredentials(userCredentialChecked, passwordCredentialChecked, approval);
        }
        catch (WorkflowCustomMessageException e) {
            log.info("user: " + user.getName() + " pageId: " + page.getIdAsString() + " approval: " + approval.getName() + " approved: " + approved + " error: " + e.getCustomMessage().html);
            throw e;
        }
        if (!byPassCommentRequired && (requireApprovalComment = this.workflowConfigurationManager.getRequireApprovalComment(true)) == RequireApprovalComment.REQUIRE && StringUtils.isEmpty((CharSequence)comment)) {
            throw new WorkflowException(String.format("Cannot apply approval <%s> on page <%s> without comment", approval.getName(), page.getIdAsString()));
        }
        PageState pageState = this.getAndInitPageState(pageWorkflows, user);
        ApprovalCheck existingCheck = approvalCheck = this.approvalAccessor.getLatestApprovalCheck(page, pageState, approval.getName(), 0);
        this.validateApproveApproval(pageWorkflows.getValueStore(), user, approval, byPassUserCondition, approvalCheck);
        String rolename = existingCheck != null ? existingCheck.getRolename(user.getName()) : null;
        String credentials = this.eSignaturesConfigurationManager.getESignaturesCredentials();
        Approver approver = new Approver(approval.getName(), user.getName(), rolename, new Date(), comment, approved, approval.getCredentials(), ESignatureCredentials.Credentials.fromString(credentials));
        if (approvalCheck != null) {
            DefaultApprovalManager.setMinimumRequiredApprovers(pageWorkflows.getValueStore(), approval, approvalCheck);
            if (approvalCheck.isCheckUpToDate(page, this.stateAccessor.getLatestState(page), true, this.attachmentManager)) {
                if (approvalCheck.isApproved()) {
                    if (approved) {
                        return approvalCheck;
                    }
                    approvalCheck = null;
                } else if (approvalCheck.isRejected(true)) {
                    if (!approved) {
                        return approvalCheck;
                    }
                    approvalCheck = null;
                }
            } else {
                approvalCheck = null;
            }
        }
        if (approvalCheck != null && approvalCheck.appendApprover(approver)) {
            approvalCheck.setState(this.stateAccessor.getLatestState(page));
            approvalCheck.setVersion(page.getVersion());
            this.checkTransitionParamsBeforeApproval(page, pageWorkflows, approved);
            this.updateApprovalCheck(page, approvalCheck);
        } else {
            approvalCheck = new ApprovalCheck(approval.getName(), approval.getWeight(), page.getVersion(), this.attachmentManager.getLatestVersionsOfAttachments((ContentEntityObject)page), approver);
            if (existingCheck != null) {
                approvalCheck.setRequiredApprovers(existingCheck.getRequiredApprovers());
                if (existingCheck.isRejected(true)) {
                    approvalCheck.setAssigneeHistory(existingCheck.getAssigneeHistory());
                }
            }
            DefaultApprovalManager.setMinimumRequiredApprovers(pageWorkflows.getValueStore(), approval, approvalCheck);
            approvalCheck.setState(this.stateAccessor.getLatestState(page));
            String[] requiredApprovers = this.selectorManager.getRequiredUsersNames(approval.getSelector(), pageWorkflows.getValueStore());
            if (requiredApprovers.length > 0) {
                approvalCheck.setRequiredApprovers(requiredApprovers);
            }
            this.checkTransitionParamsBeforeApproval(page, pageWorkflows, approved);
            this.addApprovalCheck(page, approvalCheck);
        }
        this.checkAndMarkFinalApproval(page, approval, approvalCheck);
        if (!skipApproveEvent) {
            this.publishApprovalEvent(page, approvalCheck, pageState);
        }
        pageWorkflows.getValueStore().resetPageState();
        if (log.isDebugEnabled()) {
            log.debug(page + " got " + approvalCheck);
        }
        this.indexer.reIndex((Searchable)page);
        if (log.isInfoEnabled()) {
            log.info("user: " + user.getName() + " pageId: " + page.getIdAsString() + " approval: " + approval.getName() + " approved: " + approved);
        }
        return approvalCheck;
    }

    private PageState getAndInitPageState(PageWorkflows pageWorkflows, ConfluenceUser user) {
        PageState pageState = pageWorkflows.getValueStore().getPageState();
        if (pageState == null && pageWorkflows.getStatesContainer() != null) {
            State initialState = pageWorkflows.getStatesContainer().getInitialState();
            log.info("setting initial state " + initialState.getName() + " to " + pageWorkflows.getPage());
            pageState = this.stateManager.setState(pageWorkflows.getValueStore(), initialState, true, user, null, null, pageWorkflows.getReadAck());
        }
        return pageState;
    }

    @Override
    public ApprovalCheck assignApproval(AbstractPage page, PageWorkflows pageWorkflows, String approvalName, ConfluenceUser assignee, String rolename, String comment) throws WorkflowException {
        return this.assignApproval(page, pageWorkflows, approvalName, assignee, rolename, comment, null);
    }

    private void validateAssignApproval(Approval approval, ApprovalCheck approvalCheck, PageWorkflows pageWorkflows, ConfluenceUser assignee, ApprovalManager.AssignApprovalMode mode) throws WorkflowException {
        Collection<ConfluenceUser> allowedUsers;
        String approvalName = approval.getName();
        Selector selector = approval.getSelector();
        if (!(mode == ApprovalManager.AssignApprovalMode.BYPASS_SELECTOR_CHECKS || selector != null && selector.isSelection() || approval.isAssignable())) {
            throw new WorkflowException("Approval " + approvalName + " cannot be assigned");
        }
        Collection<ConfluenceUser> excludedUsers = approval.getStatus(pageWorkflows.getValueStore(), approvalCheck).getExcludedUserApprovers();
        for (ConfluenceUser user : excludedUsers) {
            if (!user.getName().equals(assignee.getName())) continue;
            throw new WorkflowException("User " + assignee.getName() + " is excluded from " + approvalName + " approval");
        }
        if (!approval.getStatus(pageWorkflows.getValueStore(), approvalCheck).isAllowedToAssign()) {
            throw new WorkflowException("User " + AuthenticatedUserThreadLocal.getUsername() + " is not allowed to assign in " + approvalName + " approval");
        }
        if (selector != null) {
            Selectable.Selector uiSelector = this.selectorManager.makeUiSelector(selector, pageWorkflows.getValueStore());
            allowedUsers = uiSelector.getUsers();
            List<Group> allowedGroups = uiSelector.getGroups();
            if (allowedUsers.stream().noneMatch(allowedUser -> allowedUser.getName().equalsIgnoreCase(assignee.getName()))) {
                boolean belongsToAnyAllowedGroup = false;
                for (Group group : allowedGroups) {
                    try {
                        if (assignee == null || !this.groupManager.hasMembership(group, (User)assignee)) continue;
                        belongsToAnyAllowedGroup = true;
                        break;
                    }
                    catch (Exception ex) {
                        log.error("There has been an error checking the membership of the assignee {}: {}", (Object)assignee, (Object)ex.getMessage());
                    }
                }
                if (!belongsToAnyAllowedGroup) {
                    if (log.isDebugEnabled()) {
                        log.debug("Tried to assign: " + assignee.getName() + " but valid assignee list is: " + allowedUsers.stream().map(Principal::getName).toArray() + " and valid assignee groups are: " + allowedGroups.stream().map(Entity::getName).toArray());
                    }
                    throw new WorkflowException("Approval " + approvalName + " cannot be assigned to " + assignee.getName());
                }
            }
        } else {
            ApprovalStatus approvalStatus = approval.getStatus(pageWorkflows.getValueStore(), approvalCheck);
            allowedUsers = approvalStatus.getPossibleUserApprovers();
            Collection<Group> allowedGroup = approvalStatus.getPossibleGroupApprovers();
            if (!allowedUsers.isEmpty() || !allowedGroup.isEmpty()) {
                boolean validAssignee = false;
                for (ConfluenceUser user : allowedUsers) {
                    if (!user.getName().equalsIgnoreCase(assignee.getName())) continue;
                    validAssignee = true;
                    break;
                }
                if (!validAssignee) {
                    for (Group group : allowedGroup) {
                        try {
                            if (assignee == null || !this.groupManager.hasMembership(group, (User)assignee)) continue;
                            validAssignee = true;
                            break;
                        }
                        catch (Exception ex) {
                            log.error("There has been an error checking the membership of the assignee {}: {}", (Object)assignee, (Object)ex.getMessage());
                        }
                    }
                }
                if (!validAssignee) {
                    if (log.isDebugEnabled()) {
                        log.debug("Tried to assign: " + assignee.getName() + " but valid assignee list is: " + allowedUsers.stream().map(Principal::getName).toArray() + " and valid assignee groups are: " + allowedGroup.stream().map(Entity::getName).toArray());
                    }
                    throw new WorkflowException("Approval " + approvalName + " cannot be assigned to " + assignee.getName());
                }
            }
        }
    }

    @Override
    public ApprovalCheck assignApproval(AbstractPage page, PageWorkflows pageWorkflows, String approvalName, ConfluenceUser assignee, String rolename, String comment, ApprovalManager.AssignApprovalMode mode) throws WorkflowException {
        Approval approval = pageWorkflows.getApproval(approvalName);
        if (approval == null) {
            throw new WorkflowException("Invalid approval name" + approvalName);
        }
        Selector selector = approval.getSelector();
        PageState pageState = pageWorkflows.getValueStore().getPageState();
        ApprovalCheck approvalCheck = this.approvalAccessor.getLatestApprovalCheck(page, pageState, approval.getName(), 0);
        if (mode != ApprovalManager.AssignApprovalMode.BYPASS_VALIDATION) {
            this.validateAssignApproval(approval, approvalCheck, pageWorkflows, assignee, mode);
        }
        if (approvalCheck != null) {
            if (approvalCheck.isRequiredApprover(assignee.getName())) {
                return approvalCheck;
            }
            DefaultApprovalManager.setMinimumRequiredApprovers(pageWorkflows.getValueStore(), approval, approvalCheck);
            if (selector != null && selector.isSelectOne()) {
                for (String approver : approvalCheck.getRequiredApprovers()) {
                    approvalCheck.removeRequiredApprover(approver, rolename, comment);
                    this.unassign(page, pageState, approver, comment, approvalCheck, false);
                }
            }
            if (approvalCheck.getRequiredApprovers().length >= this.usersListResolver.getMaxHandledUsers()) {
                this.usersListResolver.throwMaxHandledUsersLimitReachedError();
            }
            approvalCheck.addRequiredApprover(assignee.getName(), rolename, comment);
            this.updateApprovalCheck(page, approvalCheck);
        } else {
            approvalCheck = new ApprovalCheck(approval.getName(), approval.getWeight(), page.getVersion(), this.attachmentManager.getLatestVersionsOfAttachments((ContentEntityObject)page), null);
            approvalCheck.addRequiredApprover(assignee.getName(), rolename, comment);
            DefaultApprovalManager.setMinimumRequiredApprovers(pageWorkflows.getValueStore(), approval, approvalCheck);
            approvalCheck.setState(pageState);
            this.addApprovalCheck(page, approvalCheck);
        }
        this.publishApprovalAssignEvent(page, pageState, approvalCheck, assignee, comment);
        this.indexer.reIndex((Searchable)page);
        return approvalCheck;
    }

    public static void setMinimumRequiredApprovers(ValueStore valueStore, Approval approval, ApprovalCheck approvalCheck) throws WorkflowException {
        String minStringValue = (approval.getSelector() == null || !approval.getSelector().isSelection()) && approval.getMinRequiredApprovers() != null ? approval.getMinRequiredApprovers() : approval.getSelector().getMinimum();
        int minRequiredApprovers = 0;
        if (StringUtils.isNumeric((CharSequence)minStringValue)) {
            minRequiredApprovers = Integer.parseInt(minStringValue);
        } else {
            try {
                minRequiredApprovers = Double.valueOf(valueStore.getValue(minStringValue)).intValue();
            }
            catch (NumberFormatException e) {
                log.error("Value of the value reference used to set the minimum approvers in '" + approval.getName() + "' approval, named '" + DefaultValueStore.parseValueReferenceIntoName(minStringValue) + "', is not a number.", (Throwable)e);
            }
        }
        if (minRequiredApprovers > 1) {
            approvalCheck.setMinimumApproversRequired(minRequiredApprovers);
        }
    }

    private void publishApprovalAssignEvent(AbstractPage page, PageState pageState, ApprovalCheck approvalCheck, ConfluenceUser assignee, String comment) {
        if (page instanceof Page) {
            this.eventPublisher.publish((Object)new PageApprovalAssignedEvent(this, (Page)page, pageState, approvalCheck, false, assignee, comment));
        } else if (page instanceof BlogPost) {
            this.eventPublisher.publish((Object)new BlogPostApprovalAssignedEvent(this, (BlogPost)page, pageState, approvalCheck, false, assignee, comment));
        }
    }

    private void validateUnassignApproval(Approval approval, ApprovalCheck approvalCheck, PageWorkflows pageWorkflows) throws WorkflowException {
        String approvalName = approval.getName();
        Selector selector = approval.getSelector();
        if (!(selector != null && selector.isSelection() || approval.isAssignable())) {
            throw new WorkflowException("Approval " + approvalName + " cannot be unassigned");
        }
        if (!approval.getStatus(pageWorkflows.getValueStore(), approvalCheck).isAllowedToAssign()) {
            throw new WorkflowException("User " + AuthenticatedUserThreadLocal.getUsername() + " is not allowed to unassign in " + approvalName + " approval");
        }
    }

    @Override
    public ApprovalCheck unassignApproval(AbstractPage page, PageWorkflows pageWorkflows, String approvalName, ConfluenceUser assignee, String comment) throws WorkflowException {
        Approval approval = pageWorkflows.getApproval(approvalName);
        if (approval == null) {
            throw new WorkflowException("Invalid approval name" + approvalName);
        }
        PageState pageState = pageWorkflows.getValueStore().getPageState();
        ApprovalCheck approvalCheck = this.approvalAccessor.getLatestApprovalCheck(page, pageState, approval.getName(), 0);
        if (approvalCheck == null) {
            return null;
        }
        this.validateUnassignApproval(approval, approvalCheck, pageWorkflows);
        this.checkTransitionParamsBeforeApproval(page, pageWorkflows, true);
        this.unassign(page, pageState, assignee.getName(), comment, approvalCheck, true);
        return approvalCheck;
    }

    private void unassign(AbstractPage page, PageState pageState, String assignee, String comment, ApprovalCheck approvalCheck, boolean publishEvents) throws WorkflowException {
        approvalCheck.removeRequiredApprover(assignee, "", comment);
        this.updateApprovalCheck(page, approvalCheck);
        if (publishEvents) {
            DefaultApprovalUnassignedEvent unassignedEvent = new DefaultApprovalUnassignedEvent(this, approvalCheck, page, pageState, false, approvalCheck.getLastAssignment());
            this.eventPublisher.publish((Object)unassignedEvent);
            this.publishApprovalEventAfterUnAssign(page, approvalCheck, pageState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canApprove(AbstractPage page, ConfluenceUser user, String approvalName) {
        PageWorkflows pageWorkflows = null;
        try {
            pageWorkflows = this.workflowAccessor.getWorkflows(page);
        }
        catch (WorkflowException workflowException) {
            // empty catch block
        }
        if (pageWorkflows == null) {
            return false;
        }
        Approval approval = pageWorkflows.getApproval(approvalName);
        if (approval == null) {
            return false;
        }
        ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
        try {
            AuthenticatedUserThreadLocal.set((ConfluenceUser)user);
            PageState pageState = pageWorkflows.getValueStore().getPageState();
            ApprovalCheck approvalCheck = this.approvalAccessor.getLatestApprovalCheck(page, pageState, approvalName, 0);
            this.validateApproveApproval(pageWorkflows.getValueStore(), user, approval, false, approvalCheck);
            boolean bl = true;
            return bl;
        }
        catch (WorkflowException e) {
            log.error("There has been an error validating or getting approval status:" + e);
        }
        finally {
            AuthenticatedUserThreadLocal.set((ConfluenceUser)currentUser);
        }
        return false;
    }

    private void checkCredentials(boolean userCredentialChecked, boolean passwordCredentialChecked, Approval approval) throws WorkflowCustomMessageException {
        if (approval.getCredentials() == SignatureType.NONE) {
            return;
        }
        if (approval.getCredentials() == SignatureType.PASSWORD && !passwordCredentialChecked || approval.getCredentials() == SignatureType.USERID_AND_PASSWORD && (!passwordCredentialChecked || !userCredentialChecked)) {
            throw new WorkflowCustomMessageException(Message.MessageType.ERROR, "Error", "approvalsworkflow.credentials.invalid", true, Message.MessageCode.INVALID_CREDENTIALS);
        }
    }

    @Override
    public void queueApproveChildren(AbstractPage page, String approvalName, boolean approved, String comment, String childApprovedState) {
        List children = ((Page)page).getChildren();
        for (Page child : children) {
            if (child.getParent().getId() != page.getId()) continue;
            String wiki = "{approve-page:" + approvalName + "|approved=" + (approved ? "true" : "false") + "|comment=" + comment + "}";
            if (childApprovedState != null) {
                PageState childState = this.stateAccessor.getLatestState((AbstractPage)child);
                if (childState == null || !childApprovedState.equals(childState.getState())) continue;
                this.workflowActionManager.queueAction((AbstractPage)child, wiki);
                continue;
            }
            this.workflowActionManager.queueAction((AbstractPage)child, wiki);
        }
    }

    private void validateApproveApproval(ValueStore valueStore, ConfluenceUser user, Approval approval, boolean bypassUserCondition, ApprovalCheck approvalCheck) throws WorkflowException {
        ApprovalStatus status;
        if (!valueStore.getPage().isLatestVersion()) {
            throw new WorkflowException("Cannot approve historic version");
        }
        if (user == null) {
            throw new WorkflowUserException("approvalsworkflow.approvals.anonymous-not-allowed");
        }
        try {
            status = approval.getStatus(valueStore, approvalCheck);
        }
        catch (WorkflowException e) {
            log.error("Error: " + e.getMessage());
            throw new WorkflowUserException("approvalsworkflow.approvals.cannot-determine", valueStore.getPage().getTitle() + " ,reason:[" + e.getMessage() + "]");
        }
        if (!bypassUserCondition && !status.isCanApprove()) {
            throw new WorkflowUserException("approvalsworkflow.approvals.not-allowed", (Object)approval.getName(), valueStore.getPage().getTitle());
        }
    }

    private void publishApprovalEvent(AbstractPage page, ApprovalCheck approvalCheck, PageState pageState) {
        Approver lastApprover = approvalCheck.getLastApprover();
        if (lastApprover.isApproved()) {
            if (page instanceof Page) {
                this.eventPublisher.publish((Object)new PageApprovalApproveEvent(this, (Page)page, pageState, approvalCheck, true));
                if (approvalCheck.isApproved()) {
                    this.eventPublisher.publish((Object)new PageApprovalApproveEvent(this, (Page)page, pageState, approvalCheck, false));
                }
            } else if (page instanceof BlogPost) {
                this.eventPublisher.publish((Object)new BlogPostApprovalApproveEvent(this, (BlogPost)page, pageState, approvalCheck, true));
                if (approvalCheck.isApproved()) {
                    this.eventPublisher.publish((Object)new BlogPostApprovalApproveEvent(this, (BlogPost)page, pageState, approvalCheck, false));
                }
            }
        } else if (page instanceof Page) {
            this.eventPublisher.publish((Object)new PageApprovalRejectEvent(this, (Page)page, pageState, approvalCheck, true));
            if (approvalCheck.isRejected(true)) {
                this.eventPublisher.publish((Object)new PageApprovalRejectEvent(this, (Page)page, pageState, approvalCheck, false));
            }
        } else if (page instanceof BlogPost) {
            this.eventPublisher.publish((Object)new BlogPostApprovalRejectEvent(this, (BlogPost)page, pageState, approvalCheck, true));
            if (approvalCheck.isRejected(true)) {
                this.eventPublisher.publish((Object)new BlogPostApprovalRejectEvent(this, (BlogPost)page, pageState, approvalCheck, false));
            }
        }
    }

    private void publishApprovalEventAfterUnAssign(AbstractPage page, ApprovalCheck approvalCheck, PageState pageState) {
        if (approvalCheck.isCheckUpToDate(page, pageState, true, this.attachmentManager)) {
            if (approvalCheck.isApproved()) {
                if (page instanceof Page) {
                    this.eventPublisher.publish((Object)new PageApprovalApproveEvent(this, (Page)page, pageState, approvalCheck, false));
                } else {
                    this.eventPublisher.publish((Object)new BlogPostApprovalApproveEvent(this, (BlogPost)page, pageState, approvalCheck, false));
                }
            } else if (approvalCheck.isRejected(true)) {
                if (page instanceof Page) {
                    this.eventPublisher.publish((Object)new PageApprovalRejectEvent(this, (Page)page, pageState, approvalCheck, false));
                } else {
                    this.eventPublisher.publish((Object)new BlogPostApprovalRejectEvent(this, (BlogPost)page, pageState, approvalCheck, false));
                }
            }
        }
    }

    private void checkAndMarkFinalApproval(AbstractPage page, Approval approval, ApprovalCheck approvalCheck) {
        ApprovalCheck oldFinalCheck;
        if (approvalCheck.isApproved()) {
            if (approval.isFinalApproval()) {
                this.markFinalApproval(page, approvalCheck);
            }
        } else if (approvalCheck.isRejected(true) && approval.isFinalApproval() && (oldFinalCheck = this.approvalAccessor.getFinalApprovalCheck(page)) != null && oldFinalCheck.isSameVersion(approvalCheck)) {
            this.restorePreviousFinalApprovalId(page, approval, oldFinalCheck.getId());
        }
    }

    @Override
    public void markFinalApproval(AbstractPage page, ApprovalCheck approvalCheck) {
        if (approvalCheck != null) {
            this.approvalAccessor.setFinalApprovalCheckId(page, approvalCheck.getId());
        } else {
            ApprovalCheck lastCheck = this.approvalAccessor.getLatestApprovalCheck(page);
            if (lastCheck != null) {
                this.approvalAccessor.setFinalApprovalCheckId(page, lastCheck.getId());
            } else {
                this.approvalAccessor.clearFinalApprovalId(page);
            }
        }
    }

    private void addApprovalCheck(AbstractPage page, ApprovalCheck approvalCheck) {
        ApprovalCheck[] checks = this.approvalAccessor.getApprovalChecks(page);
        ApprovalCheck[] newchecks = new ApprovalCheck[checks.length + 1];
        System.arraycopy(checks, 0, newchecks, 0, checks.length);
        newchecks[checks.length] = approvalCheck;
        approvalCheck.setId(checks.length + 1);
        this.approvalAccessor.saveApprovalChecks(page, newchecks);
        this.indexer.reIndex((Searchable)page);
    }

    private void restorePreviousFinalApprovalId(AbstractPage page, Approval approval, int approvalCheckId) {
        ApprovalCheck[] checks = this.approvalAccessor.getApprovalChecks(page);
        boolean foundPreviousCheck = false;
        for (int i = checks.length - 1; i >= 0; --i) {
            ApprovalCheck check = checks[i];
            if (check.getId() == approvalCheckId) {
                foundPreviousCheck = true;
                continue;
            }
            if (!foundPreviousCheck || !check.isApproved() || !check.getName().equals(approval.getName())) continue;
            log.warn("restoring final approval to " + check.getId() + " to " + page);
            this.markFinalApproval(page, check);
            return;
        }
        log.warn("deleting final approval from " + page);
        this.approvalAccessor.clearFinalApprovalId(page);
    }
}

