/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.util;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.comalatech.confluence.util.ActiveObjectsManager;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.validation.constraints.NotNull;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class ActiveObjectsAccessor
implements InitializingBean,
ApplicationContextAware {
    private ApplicationContext applicationContext;
    private ActiveObjects ao;
    private boolean isInitialized = false;

    public void setApplicationContext(@NotNull ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void afterPropertiesSet() throws Exception {
        ActiveObjectsManager activeObjectsManager = (ActiveObjectsManager)this.applicationContext.getBean("activeObjectsManager", ActiveObjectsManager.class);
        if (activeObjectsManager != null) {
            this.ao = activeObjectsManager.getActiveObjects();
        }
    }

    protected ActiveObjects getAo() {
        if (!this.isInitialized) {
            int count = 0;
            while (!this.isInitialized && count < 10) {
                try {
                    this.ao.moduleMetaData().awaitInitialization(1L, TimeUnit.MINUTES);
                    this.isInitialized = this.ao.moduleMetaData().isInitialized();
                    if (!this.isInitialized) continue;
                    return this.ao;
                }
                catch (InterruptedException | ExecutionException | TimeoutException exp) {
                    ++count;
                }
            }
            return null;
        }
        return this.ao;
    }

    public void setInitialized(boolean initialized) {
        this.isInitialized = initialized;
    }
}

