/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.ipc.api;

import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.longrunning.LongRunningTaskId;
import com.atlassian.confluence.util.longrunning.LongRunningTaskManager;
import com.atlassian.core.task.longrunning.LongRunningTask;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.user.User;
import com.comalatech.confluence.adhoc.AdhocWorkflowManager;
import com.comalatech.confluence.ipc.api.AbstractAdhocService;
import com.comalatech.confluence.ipc.api.InternalStateService;
import com.comalatech.confluence.ipc.task.SetStateTask;
import com.comalatech.confluence.states.StateAccessor;
import com.comalatech.confluence.states.StateManager;
import com.comalatech.confluence.states.model.PageState;
import com.comalatech.confluence.states.model.State;
import com.comalatech.confluence.states.model.StateChangeReason;
import com.comalatech.confluence.states.model.StateColour;
import com.comalatech.confluence.states.model.StateSelection;
import com.comalatech.confluence.states.model.StatesContainer;
import com.comalatech.confluence.workflow.ApprovalAccessor;
import com.comalatech.confluence.workflow.ApprovalManager;
import com.comalatech.confluence.workflow.InternalWorkflowParameterManager;
import com.comalatech.confluence.workflow.PageWorkflows;
import com.comalatech.confluence.workflow.StateSelectionManager;
import com.comalatech.confluence.workflow.WorkflowAccessor;
import com.comalatech.confluence.workflow.WorkflowCustomMessageException;
import com.comalatech.confluence.workflow.model.Approval;
import com.comalatech.confluence.workflow.model.ApprovalCheck;
import com.comalatech.confluence.workflow.rest.model.Message;
import com.comalatech.confluence.workflow.user.WorkflowAuthenticatedUserThreadLocal;
import com.comalatech.workflow.WorkflowException;
import com.comalatech.workflow.model.StateApproval;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultStateService
extends AbstractAdhocService
implements InternalStateService {
    private static final Logger log = LoggerFactory.getLogger(DefaultStateService.class);
    private final PageManager pageManager;
    private final StateAccessor stateAccessor;
    private final ApprovalAccessor approvalAccessor;
    private final ApprovalManager approvalManager;
    private final AdhocWorkflowManager adhocWorkflowManager;
    private final PermissionManager permissionManager;
    private final EventPublisher eventPublisher;
    private final TransactionTemplate transactionTemplate;
    private final SpaceManager spaceManager;
    private final LongRunningTaskManager longRunningTaskManager;
    private final AccessModeService accessModeService;
    private final InternalWorkflowParameterManager workflowParameterManager;
    private final AttachmentManager attachmentManager;
    private final DarkFeatureManager darkFeatureManager;
    private final StateSelectionManager stateSelectionManager;

    public DefaultStateService(UserAccessor userAccessor, WorkflowAccessor workflowAccessor, StateManager stateManager, PageManager pageManager, StateAccessor stateAccessor, ApprovalAccessor approvalAccessor, ApprovalManager approvalManager, AdhocWorkflowManager adhocWorkflowManager, PermissionManager permissionManager, EventPublisher eventPublisher, TransactionTemplate transactionTemplate, SpaceManager spaceManager, LongRunningTaskManager longRunningTaskManager, AccessModeService accessModeService, InternalWorkflowParameterManager workflowParameterManager, AttachmentManager attachmentManager, DarkFeatureManager darkFeatureManager, StateSelectionManager stateSelectionManager) {
        super(userAccessor, workflowAccessor, stateManager);
        this.pageManager = pageManager;
        this.stateAccessor = stateAccessor;
        this.approvalAccessor = approvalAccessor;
        this.approvalManager = approvalManager;
        this.adhocWorkflowManager = adhocWorkflowManager;
        this.permissionManager = permissionManager;
        this.eventPublisher = eventPublisher;
        this.transactionTemplate = transactionTemplate;
        this.spaceManager = spaceManager;
        this.longRunningTaskManager = longRunningTaskManager;
        this.accessModeService = accessModeService;
        this.workflowParameterManager = workflowParameterManager;
        this.attachmentManager = attachmentManager;
        this.darkFeatureManager = darkFeatureManager;
        this.stateSelectionManager = stateSelectionManager;
    }

    @Override
    public PageState getPublishedState(ContentEntityObject content) {
        AbstractPage page = (AbstractPage)content;
        PageWorkflows pageWorkflows = this.workflowAccessor.getPageWorkflows(page);
        if (pageWorkflows != null) {
            ApprovalCheck check = this.approvalAccessor.getFinalApprovalCheck(page);
            if (check == null) {
                return null;
            }
            List<PageState> states = this.stateAccessor.getPageStates(page);
            int stateId = check.getStateId();
            boolean found = false;
            ApprovalCheck[] approvalChecks = this.approvalAccessor.getApprovalChecks(page);
            for (PageState state : states) {
                if (found) {
                    this.approvalAccessor.setApprovalsAndRejections(approvalChecks, state);
                    state.setPublished(true);
                    State finalState = pageWorkflows.getState(state.getName());
                    if (finalState != null) {
                        state.setColour(finalState.getColour());
                    } else {
                        state.setColour(StateColour.GREEN.value);
                    }
                    return state;
                }
                if (state.getId() != stateId) continue;
                found = true;
            }
            if (log.isDebugEnabled()) {
                log.info("Could not retrieve final state: " + content);
            }
        }
        return null;
    }

    @Override
    public PageState getStateBeforePublishedState(ContentEntityObject content) {
        AbstractPage page = (AbstractPage)content;
        PageWorkflows pageWorkflows = this.workflowAccessor.getPageWorkflows(page);
        if (pageWorkflows != null) {
            ApprovalCheck check = this.approvalAccessor.getFinalApprovalCheck(page);
            if (check == null) {
                return null;
            }
            int idOfStateBeforePublishedState = check.getStateId();
            PageState stateBeforeFinalState = this.stateAccessor.getState(page, idOfStateBeforePublishedState);
            ApprovalCheck[] approvalChecks = this.approvalAccessor.getApprovalChecks(page);
            this.approvalAccessor.setApprovalsAndRejections(approvalChecks, stateBeforeFinalState);
            return stateBeforeFinalState;
        }
        return null;
    }

    @Override
    public PageState getCurrentState(ContentEntityObject content) {
        State initialState;
        AbstractPage page = (AbstractPage)content;
        PageState state = this.stateAccessor.getLatestState(page);
        PageWorkflows pageWorkflows = this.workflowAccessor.getPageWorkflows(page);
        if (state == null && pageWorkflows != null && (initialState = pageWorkflows.getInitialState()) != null) {
            state = new PageState(initialState.getName());
        }
        if (pageWorkflows != null) {
            state = pageWorkflows.getEnrichedPageState(state);
        }
        return state;
    }

    @Deprecated
    public List<PageState> getStates(ContentEntityObject content) {
        AbstractPage page = (AbstractPage)content;
        List<PageState> states = this.stateAccessor.getPageStates(page);
        PageWorkflows pageWorkflows = this.workflowAccessor.getPageWorkflows(page);
        ApprovalCheck[] approvalChecks = this.approvalAccessor.getApprovalChecks(page);
        HashSet<String> foundStateNames = new HashSet<String>();
        for (int i = states.size() - 1; i >= 0; --i) {
            PageState state = states.get(i);
            this.approvalAccessor.setApprovalsAndRejections(approvalChecks, state);
            if (pageWorkflows != null) {
                state.setPublished((state = pageWorkflows.getEnrichedPageState(state)).isPublished() && !foundStateNames.contains(state.getName()));
            }
            foundStateNames.add(state.getName());
        }
        return states;
    }

    @Override
    public List<StateApproval> getCurrentApprovals(ContentEntityObject content) {
        ArrayList<StateApproval> stateApprovals = new ArrayList<StateApproval>();
        if (content instanceof AbstractPage) {
            AbstractPage page = (AbstractPage)content;
            PageWorkflows pageWorkflows = this.workflowAccessor.getPageWorkflows(page);
            stateApprovals.addAll(this.approvalManager.getDecoratedApprovalChecks(pageWorkflows, false));
        }
        return stateApprovals;
    }

    @Override
    public List<String> getWorkflowStateNames(ContentEntityObject content) {
        ArrayList<String> returnList = new ArrayList<String>();
        AbstractPage page = (AbstractPage)content;
        if (page != null) {
            try {
                PageWorkflows pageWorkflows = this.workflowAccessor.getWorkflows(page);
                if (pageWorkflows != null) {
                    StatesContainer statesContainer = pageWorkflows.getStatesContainer();
                    for (State state : statesContainer.getStates()) {
                        returnList.add(state.getName());
                    }
                }
            }
            catch (com.comalatech.confluence.workflow.WorkflowException e) {
                log.error("", (Throwable)e);
            }
        }
        return returnList;
    }

    @Override
    public LongRunningTaskId setState(String stateName, String comment, boolean runInBackground, Long ... pageIds) throws WorkflowException {
        return this.setState(stateName, comment, runInBackground, true, pageIds);
    }

    @Override
    public LongRunningTaskId setState(String stateName, String comment, boolean runInBackground, boolean validate, Long ... pageIds) throws WorkflowException {
        if (!runInBackground) {
            for (Long pageId : pageIds) {
                AbstractPage content = this.pageManager.getAbstractPage(pageId.longValue());
                if (content == null) continue;
                this.setState((ContentEntityObject)content, stateName, comment, validate);
            }
            return null;
        }
        SetStateTask task = new SetStateTask(this.pageManager, this.userAccessor, this.eventPublisher, this.stateManager, this.approvalManager, this.workflowAccessor, this.stateAccessor, this.spaceManager, this.transactionTemplate, stateName, this.accessModeService, this.darkFeatureManager, pageIds);
        return this.longRunningTaskManager.startLongRunningTask((User)AuthenticatedUserThreadLocal.get(), (LongRunningTask)task);
    }

    @Override
    public LongRunningTaskId setState(String stateName, boolean override, String spaceKey) throws WorkflowException {
        SetStateTask task = new SetStateTask(this.pageManager, this.userAccessor, this.eventPublisher, this.stateManager, this.approvalManager, this.workflowAccessor, this.stateAccessor, this.spaceManager, this.transactionTemplate, override, stateName, spaceKey, this.accessModeService, this.darkFeatureManager);
        return this.longRunningTaskManager.startLongRunningTask((User)AuthenticatedUserThreadLocal.get(), (LongRunningTask)task);
    }

    @Override
    public LongRunningTaskId setState(String workflowName, String stateName, boolean override, String spaceKey) throws WorkflowException {
        SetStateTask task = new SetStateTask(this.pageManager, this.userAccessor, this.eventPublisher, this.stateManager, this.approvalManager, this.workflowAccessor, this.stateAccessor, this.spaceManager, this.transactionTemplate, workflowName, override, stateName, spaceKey, this.accessModeService, this.darkFeatureManager);
        return this.longRunningTaskManager.startLongRunningTask((User)AuthenticatedUserThreadLocal.get(), (LongRunningTask)task);
    }

    @Override
    public PageState setState(ContentEntityObject content, String stateName, String comment) throws WorkflowException {
        return this.setState(content, stateName, comment, true);
    }

    @Override
    public PageState setState(ContentEntityObject content, String stateName, String comment, boolean validate) throws WorkflowException {
        AbstractPage page = (AbstractPage)content;
        PageWorkflows pageWorkflows = this.getPageWorkflows(page);
        State state = pageWorkflows.getState(stateName);
        PageState currentPageState = this.stateAccessor.getLatestState(page);
        StateChangeReason reason = null;
        if (validate) {
            if (!this.validateStateSelection(page, state, pageWorkflows)) {
                if (this.canAdminWorkflow(page, AuthenticatedUserThreadLocal.get()) && state != null) {
                    if (log.isInfoEnabled()) {
                        log.info("Setting State " + stateName + " on page: " + content + " via admin override by user: " + AuthenticatedUserThreadLocal.getUsername());
                    }
                    reason = StateChangeReason.ADMIN_OVERRIDE;
                } else {
                    throw new WorkflowException("Invalid setState request, state: " + stateName + " is not currently valid for page " + content.getTitle());
                }
            }
            this.checkTransitionParamsBeforeSetState(page, pageWorkflows, stateName);
            StateChangeReason finalReason = reason;
            this.eventPublisher.publish(() -> finalReason);
        }
        if (state == null) {
            if (!State.isValidStateName(stateName)) {
                throw new WorkflowException("Invalid state name: " + stateName);
            }
            this.adhocWorkflowManager.addState(page, pageWorkflows.getValueStore().getPageState().getName(), stateName);
            pageWorkflows = this.getPageWorkflows(page);
            state = pageWorkflows.getState(stateName);
            if (state == null) {
                throw new WorkflowException("Could not create new state " + stateName);
            }
        }
        ConfluenceUser user = WorkflowAuthenticatedUserThreadLocal.get();
        if (state.isFinalState()) {
            ApprovalCheck check = this.approvalAccessor.getLatestApprovalCheck(page);
            if (check == null || !check.isCheckUpToDate(page, currentPageState, true, this.attachmentManager)) {
                Approval approval = this.stateManager.getOrCreatePreceedingApproval(state);
                check = reason != null && this.darkFeatureManager.isFeatureEnabledForAllUsers("comalatech.workflows.newactivity.listener.enabled") ? this.approvalManager.approvePage(page, approval, true, comment, user, true, true, true, true, true) : this.approvalManager.approvePage(page, approval, true, comment, user, true, true, true, true);
            }
            this.approvalManager.markFinalApproval(page, check);
        }
        return this.stateManager.setState(pageWorkflows.getValueStore(), state, true, user, comment, null, pageWorkflows.getReadAck(), reason);
    }

    @Override
    public PageState updateExpiryDate(ContentEntityObject content, Date newExpiryDate) {
        return this.updateExpiryDate(content, newExpiryDate, true);
    }

    @Override
    public PageState updateExpiryDate(ContentEntityObject content, Date newExpiryDate, boolean validateChangeDueDate) {
        AbstractPage page = (AbstractPage)content;
        PageState currentPageState = this.getCurrentState(content);
        if (currentPageState != null && (!validateChangeDueDate || currentPageState.isChangeDueDate())) {
            currentPageState = this.stateManager.setExpiryDate(page, newExpiryDate);
        } else {
            log.error("Attempted to set state expiry is not permitted on state: " + (currentPageState != null ? currentPageState.getName() : "null") + " on Page: " + content + " by user:  " + AuthenticatedUserThreadLocal.getUsername());
        }
        return currentPageState;
    }

    private boolean canAdminWorkflow(AbstractPage page, ConfluenceUser user) throws WorkflowException {
        return this.permissionManager.hasPermission((User)user, Permission.ADMINISTER, PermissionManager.TARGET_APPLICATION) || page.getSpace() != null && this.permissionManager.hasPermission((User)user, Permission.ADMINISTER, (Object)page.getSpace()) || this.getPageWorkflows(page) != null && this.getPageWorkflows(page).getWorkflowAdminUsers().contains(user.getName());
    }

    private void checkTransitionParamsBeforeSetState(AbstractPage page, PageWorkflows pageWorkflows, String targetStateName) throws com.comalatech.confluence.workflow.WorkflowException {
        State currentState = pageWorkflows.getState(this.stateAccessor.getStateName(page));
        State targetState = pageWorkflows.getState(targetStateName);
        if (currentState != null && targetState != null && !this.workflowParameterManager.isTransitionAllowed(page, targetState)) {
            throw new WorkflowCustomMessageException(Message.MessageType.ERROR, "Error", String.format("Cannot apply move to <%s> on page <%s> with pending required parameters", targetStateName, page.getIdAsString()), true, Message.MessageCode.INVALID_PARAMETERS);
        }
    }

    private boolean validateStateSelection(AbstractPage page, State state, PageWorkflows pageWorkflows) throws WorkflowException {
        if (state == null && !pageWorkflows.isAdhoc()) {
            return false;
        }
        if (pageWorkflows.isAdhoc()) {
            return true;
        }
        ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
        StateSelection stateSelection = this.stateSelectionManager.getStatesSelection(pageWorkflows, false);
        if (stateSelection == null) {
            return false;
        }
        List<State> allowedStates = stateSelection.getAllowedStates();
        if (!allowedStates.contains(state)) {
            return false;
        }
        PageState currentState = this.getCurrentState((ContentEntityObject)page);
        List<Approval> approvals = pageWorkflows.getApprovals(currentState);
        List<ApprovalCheck> approvalChecks = this.approvalAccessor.getApprovalChecks(page, currentState);
        if (approvalChecks.size() != approvals.size()) {
            return false;
        }
        for (ApprovalCheck approvalCheck : approvalChecks) {
            if (approvalCheck.isApproved()) continue;
            return false;
        }
        return true;
    }
}

