/*
 * Decompiled with CFR 0.152.
 */
package org.randombits.confluence.filtering.param.criteria.content;

import com.atlassian.confluence.core.ListQuery;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.spring.container.ContainerManager;
import java.util.ArrayList;
import java.util.List;
import org.randombits.confluence.filtering.criteria.Criterion;
import org.randombits.confluence.filtering.criteria.CriterionInterpreter;
import org.randombits.confluence.filtering.criteria.content.SpaceKeyCriterion;
import org.randombits.confluence.filtering.param.ListQueryParameter;
import org.randombits.confluence.filtering.param.ParameterException;
import org.randombits.confluence.filtering.param.criteria.CriterionParameter;
import org.randombits.confluence.support.MacroInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpaceKeyParameter
extends CriterionParameter
implements ListQueryParameter<Criterion> {
    public static final String SELF_SPACE = "@self";
    public static final String ALL_SPACES = "@all";
    public static final String GLOBAL_SPACES = "@global";
    public static final String PERSONAL_SPACES = "@personal";
    public static final String FAVOURITE_SPACES = "@favourite";
    public static final String FAVORITE_SPACES = "@favorite";
    private SpaceManager spaceManager;

    public SpaceKeyParameter() {
        this(SELF_SPACE);
    }

    public SpaceKeyParameter(String defaultValue) {
        super(defaultValue, "space", "spaces");
    }

    @Override
    protected CriterionInterpreter createCriterionInterpreter(MacroInfo info) {
        return new SpaceKeyCriterion.Interpreter(info.getSpace());
    }

    @Override
    public void prepareListQuery(ListQuery listQuery, MacroInfo info) throws ParameterException {
        Criterion criterion = this.createCriterion(info);
        if (criterion != null) {
            List allSpaces = this.getSpaceManager().getAllSpaces();
            ArrayList<Space> matchingSpaces = new ArrayList<Space>();
            for (Space space : allSpaces) {
                if (!criterion.matches(space)) continue;
                matchingSpaces.add(space);
            }
            listQuery.setSpaceList(matchingSpaces);
        } else {
            listQuery.setSpaceList(null);
        }
    }

    private SpaceManager getSpaceManager() {
        if (this.spaceManager == null) {
            this.spaceManager = (SpaceManager)ContainerManager.getComponent((String)"spaceManager");
        }
        return this.spaceManager;
    }
}

