/*
 * Decompiled with CFR 0.152.
 */
package org.randombits.confluence.filtering.criteria.global;

import com.atlassian.confluence.util.GeneralUtil;
import org.randombits.confluence.filtering.criteria.CriteriaException;
import org.randombits.confluence.filtering.criteria.Criterion;
import org.randombits.confluence.filtering.criteria.CriterionInterpreter;

public class BuildNumberCriterion
implements Criterion {
    private static final int UNBOUNDED_VALUE = -1;
    private int minValue = -1;
    private int maxValue = -1;

    public BuildNumberCriterion(int minValue, int maxValue) {
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    public boolean matches(Object object) {
        String buildNumber = GeneralUtil.getBuildNumber();
        int value = -1;
        try {
            Integer.parseInt(buildNumber);
        }
        catch (NumberFormatException e) {
            return false;
        }
        catch (NullPointerException e) {
            return false;
        }
        if (this.minValue >= 0 && this.minValue > value) {
            return false;
        }
        return this.maxValue < 0 || this.maxValue >= value;
    }

    public String toString() {
        return "{build number; min: " + (this.minValue == -1 ? "*" : Integer.valueOf(this.minValue)) + "; max: " + (this.maxValue == -1 ? "*" : Integer.valueOf(this.maxValue)) + "}";
    }

    public static class Interpretor
    implements CriterionInterpreter {
        private static final String UNBOUNDED_STRING = "*";

        public Criterion createCriterion(String value) throws CriteriaException {
            String[] range = value.trim().split("\\S\\-\\S");
            if (range.length == 0) {
                throw new CriteriaException("The value must have at least one build number: " + value);
            }
            if (range.length > 2) {
                throw new CriteriaException("The value can have at most a 'from' and 'to' value: " + value);
            }
            int minValue = this.getValue(range[0]);
            int maxValue = range.length == 2 ? this.getValue(range[1]) : minValue;
            return new BuildNumberCriterion(minValue, maxValue);
        }

        private int getValue(String value) throws CriteriaException {
            try {
                if (UNBOUNDED_STRING.equals(value)) {
                    return -1;
                }
                return Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                throw new CriteriaException("Invalid number value: " + value);
            }
        }
    }
}

