/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowcontainer.action;

import com.atlassian.confluence.compat.api.service.accessmode.ReadOnlyAccessBlocked;
import com.atlassian.core.util.PairType;
import com.comalatech.confluence.adhoc.notification.WorkflowNotificationConfigManager;
import com.comalatech.confluence.adhoc.notification.model.NotificationType;
import com.comalatech.confluence.adhoc.notification.model.SpaceNotifications;
import com.comalatech.confluence.workflowcontainer.action.SpaceConfigurationAction;
import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.List;
import javax.servlet.http.HttpSession;

public class SpaceNotificationsConfigAction
extends SpaceConfigurationAction {
    private final String CONFIG_SUCCESS_KEY = "comalatech.awp.space.workflows.notification.config.success";
    private WorkflowNotificationConfigManager workflowNotificationConfigManager;
    private String spaceNotificationsModetaskAssigned;
    private String spaceNotificationsModetaskPageWatcher;
    private String spaceNotificationsModeapprovalAssigned;
    private String spaceNotificationsModestateExpired;
    private String spaceNotificationsModereadConfirmation;
    private String docoUrl = "https://apps.appf.re/cdmdc/doc/spacenotifications/CH5uq5";

    @Override
    public String execute() throws Exception {
        super.execute();
        HttpSession session = this.getCurrentRequest().getSession();
        if (session.getAttribute("comalatech.awp.space.workflows.notification.config.success") != null && session.getAttribute("comalatech.awp.space.workflows.notification.config.success").equals("success")) {
            this.addActionMessage(this.getText("comalatech.awp.space.workflows.notification.config.success"));
            session.removeAttribute("comalatech.awp.space.workflows.notification.config.success");
        }
        return "success";
    }

    @ReadOnlyAccessBlocked
    public String saveSpaceNotificationsMode() throws Exception {
        this.workflowNotificationConfigManager.setSpaceNotificationsMode(new SpaceNotifications(NotificationType.TASK_ASSIGNMENT, SpaceNotifications.Mode.valueOf(this.spaceNotificationsModetaskAssigned)), this.getSpaceKey());
        this.workflowNotificationConfigManager.setSpaceNotificationsMode(new SpaceNotifications(NotificationType.TASK_PAGEWATCHER, SpaceNotifications.Mode.valueOf(this.spaceNotificationsModetaskPageWatcher)), this.getSpaceKey());
        this.workflowNotificationConfigManager.setSpaceNotificationsMode(new SpaceNotifications(NotificationType.APPROVAL_ASSIGNMENT, SpaceNotifications.Mode.valueOf(this.spaceNotificationsModeapprovalAssigned)), this.getSpaceKey());
        this.workflowNotificationConfigManager.setSpaceNotificationsMode(new SpaceNotifications(NotificationType.STATE_EXPIRED, SpaceNotifications.Mode.valueOf(this.spaceNotificationsModestateExpired)), this.getSpaceKey());
        this.workflowNotificationConfigManager.setSpaceNotificationsMode(new SpaceNotifications(NotificationType.READ_CONFIRMATION, SpaceNotifications.Mode.valueOf(this.spaceNotificationsModereadConfirmation)), this.getSpaceKey());
        this.getCurrentRequest().getSession().setAttribute("comalatech.awp.space.workflows.notification.config.success", (Object)"success");
        return "success";
    }

    public List<String> getNotificationTypeList() {
        return new ImmutableList.Builder().add((Object)NotificationType.TASK_ASSIGNMENT.getName()).add((Object)NotificationType.TASK_PAGEWATCHER.getName()).add((Object)NotificationType.APPROVAL_ASSIGNMENT.getName()).add((Object)NotificationType.STATE_EXPIRED.getName()).add((Object)NotificationType.READ_CONFIRMATION.getName()).build();
    }

    public List<PairType> getSpaceNotificationsModeList(String type) {
        boolean isNotificationEnabled = this.workflowNotificationConfigManager.isNotificationEnabled(NotificationType.getByName(type));
        String notificationConfig = isNotificationEnabled ? this.getText("com.comalatech.notification.config.enabled") : this.getText("com.comalatech.notification.config.disabled");
        return new ImmutableList.Builder().add((Object)new PairType((Serializable)((Object)SpaceNotifications.Mode.DEFAULT), (Serializable)((Object)this.getText(SpaceNotifications.Mode.DEFAULT.getKey(), new String[]{notificationConfig})))).add((Object)new PairType((Serializable)((Object)SpaceNotifications.Mode.ENABLED), (Serializable)((Object)this.getText(SpaceNotifications.Mode.ENABLED.getKey())))).add((Object)new PairType((Serializable)((Object)SpaceNotifications.Mode.DISABLED), (Serializable)((Object)this.getText(SpaceNotifications.Mode.DISABLED.getKey())))).build();
    }

    public String getSpaceNotificationsMode(String type) {
        SpaceNotifications.Mode mode = this.workflowNotificationConfigManager.getSpaceNotificationsMode(this.getSpaceKey(), NotificationType.getByName(type));
        return mode.name();
    }

    public void setSpaceNotificationsModetaskAssigned(String spaceNotificationsModetaskAssigned) {
        this.spaceNotificationsModetaskAssigned = spaceNotificationsModetaskAssigned;
    }

    public void setSpaceNotificationsModetaskPageWatcher(String spaceNotificationsModetaskPageWatcher) {
        this.spaceNotificationsModetaskPageWatcher = spaceNotificationsModetaskPageWatcher;
    }

    public void setSpaceNotificationsModeapprovalAssigned(String spaceNotificationsModeapprovalAssigned) {
        this.spaceNotificationsModeapprovalAssigned = spaceNotificationsModeapprovalAssigned;
    }

    public void setWorkflowNotificationConfigManager(WorkflowNotificationConfigManager workflowNotificationConfigManager) {
        this.workflowNotificationConfigManager = workflowNotificationConfigManager;
    }

    public void setSpaceNotificationsModestateExpired(String spaceNotificationsModestateExpired) {
        this.spaceNotificationsModestateExpired = spaceNotificationsModestateExpired;
    }

    public void setSpaceNotificationsModereadConfirmation(String spaceNotificationsModereadConfirmation) {
        this.spaceNotificationsModereadConfirmation = spaceNotificationsModereadConfirmation;
    }

    public String getDocoUrl() {
        return this.docoUrl;
    }
}

