/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.dataextractor.resources;

import com.atlassian.confluence.compat.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.util.longrunning.LongRunningTaskId;
import com.comalatech.confluence.dataextractor.DataExtractorManager;
import com.comalatech.confluence.dataextractor.resources.AbstractDataExtractorResource;
import com.comalatech.confluence.license.WorkflowsFeatureManager;
import com.comalatech.confluence.workflow.esignatures.resources.model.RestPopulationJob;
import com.comalatech.confluence.workflow.rest.model.PermissionRequired;
import com.webcohesion.enunciate.metadata.rs.ResponseCode;
import com.webcohesion.enunciate.metadata.rs.StatusCodes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/dataextractor/space/")
public class DataExtractorResource
extends AbstractDataExtractorResource {
    private final DataExtractorManager dataExtractorManager;

    public DataExtractorResource(PermissionManager permissionManager, WorkflowsFeatureManager workflowsFeatureManager, SpaceManager spaceManager, DataExtractorManager dataExtractorManager) {
        super(permissionManager, workflowsFeatureManager, spaceManager);
        this.dataExtractorManager = dataExtractorManager;
    }

    @ReadOnlyAccessAllowed
    @POST
    @Path(value="/{spaceKey}/populate")
    @PermissionRequired(value={"ADMINISTER"})
    @Produces(value={"application/json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Long running task started"), @ResponseCode(code=403, condition="User is not administrator"), @ResponseCode(code=400, condition="Space key is null or does not exists"), @ResponseCode(code=500, condition="Error starting the job")})
    public Response startSpacePropertiesPopulationJob(@PathParam(value="spaceKey") String spaceKey) {
        final Space space = this.spaceManager.getSpace(spaceKey);
        if (space == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        return new AbstractDataExtractorResource.RestCommand(spaceKey){

            @Override
            public Response doExecute() {
                LongRunningTaskId longRunningTaskId = DataExtractorResource.this.dataExtractorManager.launchPopulatorTaskForSpace(space);
                return DataExtractorResource.this.buildRestDataExtractorPopulationJobResponse(longRunningTaskId.toString());
            }
        }.execute();
    }

    protected Response buildRestDataExtractorPopulationJobResponse(String jobId) {
        RestPopulationJob restPopulationJob = new RestPopulationJob(jobId);
        return Response.ok().entity((Object)restPopulationJob).type("application/json").build();
    }
}

