/*
 * Decompiled with CFR 0.152.
 */
package org.randombits.storage;

import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.randombits.storage.AbstractStorage;
import org.randombits.storage.Aliasable;
import org.randombits.storage.Storage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChainedStorage
extends AbstractStorage
implements Aliasable {
    private static final Accessor<Boolean> BOOLEAN_ACCESSOR = new Accessor<Boolean>(){

        @Override
        public Boolean get(Storage store, String name) {
            return store.getBoolean(name, null);
        }

        @Override
        public void set(Storage store, String name, Boolean value) {
            store.setBoolean(name, value);
        }
    };
    private static final Accessor<Date> DATE_ACCESSOR = new Accessor<Date>(){

        @Override
        public Date get(Storage store, String name) {
            return store.getDate(name, null);
        }

        @Override
        public void set(Storage store, String name, Date value) {
            store.setDate(name, value);
        }
    };
    private static final Accessor<Double> DOUBLE_ACCESSOR = new Accessor<Double>(){

        @Override
        public Double get(Storage store, String name) {
            return store.getDouble(name, null);
        }

        @Override
        public void set(Storage store, String name, Double value) {
            store.setDouble(name, value);
        }
    };
    private static final Accessor<Integer> INTEGER_ACCESSOR = new Accessor<Integer>(){

        @Override
        public Integer get(Storage store, String name) {
            return store.getInteger(name, null);
        }

        @Override
        public void set(Storage store, String name, Integer value) {
            store.setInteger(name, value);
        }
    };
    private static final Accessor<Long> LONG_ACCESSOR = new Accessor<Long>(){

        @Override
        public Long get(Storage store, String name) {
            return store.getLong(name, null);
        }

        @Override
        public void set(Storage store, String name, Long value) {
            store.setLong(name, value);
        }
    };
    private static final Accessor<Number> NUMBER_ACCESSOR = new Accessor<Number>(){

        @Override
        public Number get(Storage store, String name) {
            return store.getNumber(name, null);
        }

        @Override
        public void set(Storage store, String name, Number value) {
        }
    };
    private static final Accessor<List<?>> OBJECT_LIST_ACCESSOR = new Accessor<List<?>>(){

        @Override
        public List<?> get(Storage store, String name) {
            return store.getObjectList(name, null);
        }

        @Override
        public void set(Storage store, String name, List<?> value) {
            store.setObjectList(name, value);
        }
    };
    private static final Accessor<String> STRING_ACCESSOR = new Accessor<String>(){

        @Override
        public String get(Storage store, String name) {
            return store.getString(name, null);
        }

        @Override
        public void set(Storage store, String name, String value) {
            store.setString(name, value);
        }
    };
    private static final Accessor<String[]> STRING_ARRAY_ACCESSOR = new Accessor<String[]>(){

        @Override
        public String[] get(Storage store, String name) {
            return store.getStringArray(name, null);
        }

        @Override
        public void set(Storage store, String name, String[] value) {
            store.setStringArray(name, value);
        }
    };
    private static final Accessor<Object> OBJECT_ACCESSOR = new Accessor<Object>(){

        @Override
        public Object get(Storage store, String name) {
            return store.getObject(name, null);
        }

        @Override
        public void set(Storage store, String name, Object value) {
            store.setObject(name, value);
        }
    };
    private Storage[] stores;
    private Storage writableStore;
    private Set<String> writableSet;
    private boolean forceReadOnly;

    public ChainedStorage(boolean forceReadOnly, Storage ... stores) {
        this.forceReadOnly = forceReadOnly;
        this.setStores(stores);
    }

    public ChainedStorage(Storage ... stores) {
        this(false, stores);
    }

    protected ChainedStorage() {
    }

    protected void setStores(Storage ... stores) {
        this.stores = new Storage[stores.length];
        System.arraycopy(stores, 0, this.stores, 0, this.stores.length);
        this.writableStore = null;
        this.writableSet = null;
        if (!this.forceReadOnly) {
            for (int i = 0; i < stores.length; ++i) {
                if (this.writableStore != null || stores[i].isReadOnly()) continue;
                this.writableStore = stores[i];
                this.writableSet = new HashSet<String>();
            }
        }
    }

    @Override
    public void closeBox() {
        for (int i = 0; i < this.stores.length; ++i) {
            this.stores[i].closeBox();
        }
        super.closeBox();
    }

    @Override
    public boolean removeBox(String name) {
        this.checkReadOnly();
        boolean allRemoved = true;
        for (int i = 0; i < this.stores.length; ++i) {
            if (this.stores[i].removeBox(name)) continue;
            allRemoved = false;
        }
        return allRemoved;
    }

    private <T> T get(String name, T def, Accessor<T> getter) {
        for (int i = 0; i < this.stores.length; ++i) {
            Storage store = this.stores[i];
            T value = getter.get(store, name);
            if (value == null && (store != this.writableStore || !this.writableSet.contains(this.writableStore.makePath(name)))) continue;
            return value;
        }
        return def;
    }

    @Override
    public Boolean getBoolean(String name, Boolean def) {
        return this.get(name, def, BOOLEAN_ACCESSOR);
    }

    @Override
    public Date getDate(String name, Date def) {
        return this.get(name, def, DATE_ACCESSOR);
    }

    @Override
    public Double getDouble(String name, Double def) {
        return this.get(name, def, DOUBLE_ACCESSOR);
    }

    @Override
    public Integer getInteger(String name, Integer def) {
        return this.get(name, def, INTEGER_ACCESSOR);
    }

    @Override
    public Long getLong(String name, Long def) {
        return this.get(name, def, LONG_ACCESSOR);
    }

    @Override
    public Number getNumber(String name, Number def) {
        return this.get(name, def, NUMBER_ACCESSOR);
    }

    @Override
    public <T> T getObject(String name, T def, Class<T> type) {
        return this.get(name, def, new ObjectAccessor<T>(type));
    }

    @Override
    public List<?> getObjectList(String name, List<?> def) {
        return this.get(name, def, OBJECT_LIST_ACCESSOR);
    }

    @Override
    public String getString(String name, String def) {
        return this.get(name, def, STRING_ACCESSOR);
    }

    @Override
    public String[] getStringArray(String name, String[] def) {
        return this.get(name, def, STRING_ARRAY_ACCESSOR);
    }

    @Override
    public boolean isReadOnly() {
        return this.forceReadOnly || this.writableStore == null;
    }

    @Override
    public Set<String> nameSet() {
        HashSet<String> names = new HashSet<String>();
        for (int i = 0; i < this.stores.length; ++i) {
            Set<String> sNames = this.stores[i].nameSet();
            if (sNames == null) continue;
            names.addAll(sNames);
        }
        return names;
    }

    @Override
    public void openBox(String name) {
        super.openBox(name);
        for (int i = 0; i < this.stores.length; ++i) {
            this.stores[i].openBox(name);
        }
    }

    private <T> void set(String name, T value, Accessor<T> accessor) {
        this.checkReadOnly();
        accessor.set(this.writableStore, name, value);
        this.writableSet.add(this.writableStore.makePath(name));
    }

    @Override
    public void setBoolean(String name, Boolean value) {
        this.set(name, value, BOOLEAN_ACCESSOR);
    }

    @Override
    public void setDate(String name, Date value) {
        this.set(name, value, DATE_ACCESSOR);
    }

    @Override
    public void setDouble(String name, Double value) {
        this.set(name, value, DOUBLE_ACCESSOR);
    }

    @Override
    public void setInteger(String name, Integer value) {
        this.set(name, value, INTEGER_ACCESSOR);
    }

    @Override
    public void setLong(String name, Long value) {
        this.set(name, value, LONG_ACCESSOR);
    }

    @Override
    public void setObject(String name, Object value) {
        this.set(name, value, OBJECT_ACCESSOR);
    }

    @Override
    public void setObjectList(String name, List<?> value) {
        this.set(name, value, OBJECT_LIST_ACCESSOR);
    }

    @Override
    public void setString(String name, String value) {
        this.set(name, value, STRING_ACCESSOR);
    }

    @Override
    public void setStringArray(String name, String[] value) {
        this.set(name, value, STRING_ARRAY_ACCESSOR);
    }

    public int getStoreCount() {
        return this.stores != null ? this.stores.length : 0;
    }

    public Storage getStore(int index) {
        try {
            if (this.stores != null) {
                return this.stores[index];
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        throw new IndexOutOfBoundsException(String.valueOf(index));
    }

    @Override
    public void addAlias(String alias, Class<?> aliasedClass) {
        if (this.stores != null) {
            for (int i = 0; i < this.stores.length; ++i) {
                if (!(this.stores[i] instanceof Aliasable)) continue;
                ((Aliasable)((Object)this.stores[i])).addAlias(alias, aliasedClass);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ObjectAccessor<T>
    implements Accessor<T> {
        private final Class<T> type;

        public ObjectAccessor(Class<T> type) {
            this.type = type;
        }

        @Override
        public T get(Storage store, String name) {
            return store.getObject(name, null, this.type);
        }

        @Override
        public void set(Storage store, String name, T value) {
            store.setObject(name, value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface Accessor<T> {
        public T get(Storage var1, String var2);

        public void set(Storage var1, String var2, T var3);
    }
}

