/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowcontainer.model;

import com.atlassian.core.util.PairType;
import com.opensymphony.util.TextUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SerializableMacro {
    private static final String[] INDENTS = new String[]{"", "    ", "        ", "            ", "                ", "                     ", "                         "};
    private String name;
    private int depth;
    private List<PairType> parameters;
    boolean hasBody;
    boolean bodyPreformatted;
    private List<SerializableMacro> insideMacros;
    private String body;

    public SerializableMacro() {
        this("dummy");
    }

    public SerializableMacro(String name) {
        this.name = name;
        this.depth = 0;
        this.parameters = new ArrayList<PairType>();
        this.insideMacros = new ArrayList<SerializableMacro>();
    }

    public SerializableMacro(String name, boolean hasBody) {
        this(name);
        this.hasBody = hasBody;
    }

    public SerializableMacro setBody(String body) {
        if (body != null) {
            this.hasBody = true;
        }
        this.body = body;
        return this;
    }

    public SerializableMacro addMacro(SerializableMacro macro) {
        if (macro == null) {
            return this;
        }
        this.hasBody = true;
        this.insideMacros.add(macro);
        return this;
    }

    public SerializableMacro addParameter(Object value) {
        this.addParameter((String)null, value);
        return this;
    }

    public SerializableMacro addParameter(String key, Object value) {
        if (value != null && TextUtils.stringSet((String)value.toString())) {
            this.parameters.add(new PairType((Serializable)((Object)key), (Serializable)((Object)value.toString())));
        }
        return this;
    }

    public SerializableMacro addParameter(String[] key, Object value) {
        this.addParameter(key[0], value);
        return this;
    }

    public SerializableMacro addParameters(Map<String, String> parameters) {
        for (Map.Entry<String, String> parameter : parameters.entrySet()) {
            this.addParameter(parameter.getKey(), (Object)parameter.getValue());
        }
        return this;
    }

    public String getParameterValue(String parameterKey) {
        if (this.parameters != null) {
            for (PairType parameter : this.parameters) {
                if (parameter.getKey() == null || !parameter.getKey().equals(parameterKey)) continue;
                return parameter.getValue().toString();
            }
        }
        return null;
    }

    public String toString() {
        String indent = this.getIndent(this.depth);
        StringBuffer sb = new StringBuffer();
        sb.append(indent).append('{').append(this.name);
        String separator = ":";
        for (PairType parameter : this.parameters) {
            Serializable key = parameter.getKey();
            String value = (String)((Object)parameter.getValue());
            sb.append(separator);
            if (key != null) {
                sb.append(key).append("=");
            }
            sb.append(value);
            separator = "|";
        }
        sb.append("}");
        if (!this.bodyPreformatted) {
            sb.append("\n");
        }
        for (SerializableMacro insideMacro : this.insideMacros) {
            insideMacro.depth = this.depth + 1;
            sb.append(insideMacro);
        }
        if (this.body != null) {
            if (this.bodyPreformatted) {
                sb.append(this.body);
            } else {
                String[] lines;
                String bodyIndent = this.getIndent(this.depth + 1);
                for (String line : lines = this.body.split("\n")) {
                    sb.append(bodyIndent).append(line.trim()).append("\n");
                }
            }
        }
        if (this.hasBody) {
            if (!this.bodyPreformatted) {
                sb.append(indent);
            }
            sb.append("{").append(this.name).append("}\n");
        }
        return sb.toString();
    }

    private String getIndent(int depth) {
        if (depth >= INDENTS.length) {
            depth = INDENTS.length - 1;
        }
        return INDENTS[depth];
    }

    public boolean isBodyPreformatted() {
        return this.bodyPreformatted;
    }

    public void setBodyPreformatted(boolean bodyPreformatted) {
        this.bodyPreformatted = bodyPreformatted;
    }

    public ParsedParameters getParameters() {
        return new ParsedParameters(this.parameters);
    }

    public static class ParsedParameters {
        Map<String, String> params;
        public String value;
        public boolean not;
        public boolean all;
        public boolean greaterThan;
        public boolean lessThan;
        public String metadataName;

        public ParsedParameters(List<PairType> parameters) {
            this.params = new HashMap<String, String>(parameters.size());
            for (PairType parameter : parameters) {
                String key = (String)((Object)parameter.getKey());
                if (key.startsWith("@")) {
                    if (key.endsWith("@")) {
                        key = key.substring(0, key.length() - 1);
                    }
                    this.metadataName = key.substring(1);
                }
                this.params.put(key, (String)((Object)parameter.getValue()));
            }
        }

        public boolean has(String key) {
            this.all = false;
            this.not = false;
            this.greaterThan = false;
            this.lessThan = false;
            this.value = this.params.get(key);
            if (this.value == null) {
                return false;
            }
            if (this.value.startsWith("!")) {
                this.value = this.value.substring(1);
                this.not = true;
            } else if (this.value.startsWith("&")) {
                this.value = this.value.substring(1);
                this.all = true;
            }
            if (this.value.equalsIgnoreCase("true")) {
                this.not = false;
            } else if (this.value.equalsIgnoreCase("false")) {
                this.not = true;
            }
            if (this.value.startsWith("<")) {
                this.lessThan = true;
                this.value = this.value.substring(1);
            } else if (this.value.startsWith(">")) {
                this.greaterThan = true;
                this.value = this.value.substring(1);
            }
            return true;
        }

        public boolean isMetadata() {
            return this.metadataName != null && this.has("@" + this.metadataName);
        }

        public String toString() {
            return this.params.toString();
        }
    }
}

