/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.user;

import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.ConfluenceUserImpl;
import com.atlassian.confluence.user.UserAccessor;
import com.comalatech.confluence.license.WorkflowsFeatureManager;
import com.comalatech.confluence.workflow.user.WorkflowUserAccessor;

public class WorkflowUserAccessorImpl
implements WorkflowUserAccessor {
    public static final String WORKFLOW_USERNAME = "com.comalatech.workflow";
    public static final String WORKFLOW_USER_FULLNAME = "Comala Document Management";
    public static final String WORKFLOW_USER_PICTURE_PATH = "%s/download/resources/%s:workflowResources/images/adhocworkflows-logo-72x72.png";
    protected static final ConfluenceUser WORKFLOW_USER = new ConfluenceUserImpl("com.comalatech.workflow", "Comala Document Management", "support@comalatech.com");
    public static final String CDM_USERNAME = "com.comalatech.workflow";
    public static final String CDC_USERNAME = "com.comalatech.cloud.approvals";
    public static final String CDA_USERNAME = "com.comalatech.workflow.approvals";
    public static final String CDM_USER_FULLNAME = "Comala Document Management";
    public static final String CDC_USER_FULLNAME = "Comala Document Control";
    public static final String CDA_USER_FULLNAME = "Comala Document Approval";
    public static final String CDM_USER_PICTURE_PATH = "%s/download/resources/%s:workflowResources/images/adhocworkflows-logo-72x72.png";
    public static final String CDC_USER_PICTURE_PATH = "%s/download/resources/%s:workflowResources/images/workflows_lite_logo-76x76.png";
    public static final String CDA_USER_PICTURE_PATH = "%s/download/resources/%s:workflowResources/images/approvals_logo-76x76.png";
    protected static final ConfluenceUser CDM_USER = new ConfluenceUserImpl("com.comalatech.workflow", "Comala Document Management", "support@comalatech.com");
    protected static final ConfluenceUser CDC_USER = new ConfluenceUserImpl("com.comalatech.cloud.approvals", "Comala Document Control", "support@comalatech.com");
    protected static final ConfluenceUser CDA_USER = new ConfluenceUserImpl("com.comalatech.workflow.approvals", "Comala Document Approval", "support@comalatech.com");
    protected final UserAccessor userAccessor;
    protected final BootstrapManager bootstrapManager;
    protected final WorkflowsFeatureManager workflowsFeatureManager;

    public WorkflowUserAccessorImpl(UserAccessor userAccessor, BootstrapManager bootstrapManager, WorkflowsFeatureManager workflowsFeatureManager) {
        this.userAccessor = userAccessor;
        this.bootstrapManager = bootstrapManager;
        this.workflowsFeatureManager = workflowsFeatureManager;
    }

    @Override
    public ConfluenceUser getUser(String username) {
        if ("com.comalatech.workflow".equals(username)) {
            return this.getAddonUser();
        }
        return this.userAccessor.getUserByName(username);
    }

    @Override
    public ConfluenceUser getWorkflowsUser() {
        return WORKFLOW_USER;
    }

    @Override
    public ConfluenceUser getAddonUser() {
        String app;
        switch (app = this.workflowsFeatureManager.getPluginKey()) {
            case "com.comalatech.workflow": {
                return CDM_USER;
            }
            case "com.comalatech.workflow.approvals": {
                return CDA_USER;
            }
            case "com.comalatech.cloud.approvals": {
                return CDC_USER;
            }
        }
        return null;
    }

    @Override
    public String getWorkflowUserAvatarPath() {
        return String.format("%s/download/resources/%s:workflowResources/images/adhocworkflows-logo-72x72.png", this.bootstrapManager.getWebAppContextPath(), this.workflowsFeatureManager.getPluginKey());
    }

    @Override
    public String getAddonUserAvatarPath() {
        String app;
        switch (app = this.workflowsFeatureManager.getPluginKey()) {
            case "com.comalatech.workflow": {
                return String.format("%s/download/resources/%s:workflowResources/images/adhocworkflows-logo-72x72.png", this.bootstrapManager.getWebAppContextPath(), app);
            }
            case "com.comalatech.workflow.approvals": {
                return String.format(CDA_USER_PICTURE_PATH, this.bootstrapManager.getWebAppContextPath(), app);
            }
            case "com.comalatech.cloud.approvals": {
                return String.format(CDC_USER_PICTURE_PATH, this.bootstrapManager.getWebAppContextPath(), app);
            }
        }
        return String.format("%s/download/resources/%s:workflowResources/images/adhocworkflows-logo-72x72.png", this.bootstrapManager.getWebAppContextPath(), this.workflowsFeatureManager.getPluginKey());
    }
}

