/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.supportconsole.mappers;

import com.atlassian.confluence.spaces.Space;
import com.comalatech.confluence.adhoc.notification.WorkflowNotificationConfigManager;
import com.comalatech.confluence.adhoc.notification.model.NotificationType;
import com.comalatech.confluence.adhoc.notification.model.SpaceNotifications;
import com.comalatech.confluence.workflow.WorkflowConfigurationManager;
import com.comalatech.confluence.workflow.supportconsole.mappers.contract.SupportConsoleReportDataPopulator;
import com.comalatech.confluence.workflow.supportconsole.model.SpaceConfigurationData;
import com.comalatech.confluence.workflowcontainer.model.WorkflowVisibilityInternal;
import com.comalatech.workflow.WorkflowParameterManager;
import com.comalatech.workflow.model.MacroTransformStatus;
import com.comalatech.workflow.model.PageUpdateResetApprovalStatus;
import com.comalatech.workflow.model.TasksMode;
import com.comalatech.workflow.model.WorkflowParameter;
import java.util.ArrayList;
import java.util.List;

public class SpaceConfigDataPopulator
implements SupportConsoleReportDataPopulator<SpaceConfigurationData, Space> {
    private final WorkflowConfigurationManager configurationManager;
    private final WorkflowNotificationConfigManager notificationConfigManager;
    private final WorkflowParameterManager workflowParameterManager;
    private final String DEFAULT_SETTING = "Default (%s)";

    public SpaceConfigDataPopulator(WorkflowConfigurationManager configurationManager, WorkflowNotificationConfigManager workflowNotificationConfigManager, WorkflowParameterManager workflowParameterManager) {
        this.configurationManager = configurationManager;
        this.notificationConfigManager = workflowNotificationConfigManager;
        this.workflowParameterManager = workflowParameterManager;
    }

    @Override
    public SpaceConfigurationData populateForTarget(Space target) {
        return SpaceConfigurationData.builder().workflowActivityAndDraftsVisibility(this.getSpaceWorkflowActivityAndDraftsVisibilityValue(target)).tasksMode(this.getSpaceTasksMode(target)).updateResetApproval(this.getResetApproval(target)).defaultView(this.getDefaultView(target)).publishedViewMacro(this.getPublishedViewMacro(target)).spaceParameters(this.getSpaceParameters(target)).taskAssigneeNotification(this.getTaskAssigneeNotification(target)).taskPageWatchersNotification(this.getTaskPageWatchersNotification(target)).approvalAssigneeNotification(this.getApprovalAssigneeNotification(target)).stateExpiredNotification(this.getStateExpiredNotification(target)).readConfirmationNotification(this.getReadConfirmationNotification(target)).build();
    }

    private String getSpaceWorkflowActivityAndDraftsVisibilityValue(Space target) {
        String spaceText;
        WorkflowVisibilityInternal spaceWorkflowVisibility = this.configurationManager.getHistoryVisibility(target.getKey(), false);
        if (spaceWorkflowVisibility.equals((Object)WorkflowVisibilityInternal.DEFAULT)) {
            WorkflowVisibilityInternal workflowVisibility = this.configurationManager.getHistoryVisibility(target.getKey(), true);
            spaceText = String.format("Default (%s)", String.valueOf((Object)workflowVisibility));
        } else {
            spaceText = String.valueOf((Object)spaceWorkflowVisibility);
        }
        return spaceText;
    }

    private String getSpaceTasksMode(Space target) {
        String spaceTasksModeText;
        TasksMode spaceTasksMode = this.configurationManager.getTasksMode(target);
        if (spaceTasksMode.equals((Object)TasksMode.DEFAULT)) {
            TasksMode tasksMode = this.configurationManager.getTasksMode(target.getKey(), true);
            spaceTasksModeText = String.format("Default (%s)", String.valueOf((Object)tasksMode));
        } else {
            spaceTasksModeText = String.valueOf((Object)spaceTasksMode);
        }
        return spaceTasksModeText;
    }

    private String getResetApproval(Space target) {
        String spaceResetApprovalText;
        PageUpdateResetApprovalStatus spaceResetApproval = this.configurationManager.getResetApprovalStatus(target);
        if (spaceResetApproval.equals((Object)PageUpdateResetApprovalStatus.DEFAULT)) {
            PageUpdateResetApprovalStatus resetApproval = this.configurationManager.getResetApprovalStatus(target.getKey(), true);
            spaceResetApprovalText = String.format("Default (%s)", String.valueOf((Object)resetApproval));
        } else {
            spaceResetApprovalText = String.valueOf((Object)spaceResetApproval);
        }
        return spaceResetApprovalText;
    }

    private String getDefaultView(Space target) {
        boolean isViewDraftByDefault = this.configurationManager.isViewDraftByDefault(target);
        String defaultViewText = isViewDraftByDefault ? "LATEST" : "PUBLISHED";
        return defaultViewText;
    }

    private String getPublishedViewMacro(Space target) {
        String spacePublishedViewMacroText;
        MacroTransformStatus spacePublishedViewMacro = this.configurationManager.getMacroTransformStatus(target);
        if (spacePublishedViewMacro.equals((Object)MacroTransformStatus.DEFAULT)) {
            MacroTransformStatus publishedViewMacro = this.configurationManager.getMacroTransformEnable(target.getKey(), true);
            spacePublishedViewMacroText = String.format("Default (%s)", String.valueOf((Object)publishedViewMacro));
        } else {
            spacePublishedViewMacroText = String.valueOf((Object)spacePublishedViewMacro);
        }
        return spacePublishedViewMacroText;
    }

    private List<String> getSpaceParameters(Space target) {
        ArrayList<String> spaceParamsTexts = new ArrayList<String>();
        List<WorkflowParameter> spaceParams = this.workflowParameterManager.getSpaceWorkflowsParameters(target.getKey());
        for (WorkflowParameter workflowParameter : spaceParams) {
            String SPACE_PARAM = "%s (%s) = %s";
            spaceParamsTexts.add(String.format(SPACE_PARAM, workflowParameter.getName(), String.valueOf((Object)workflowParameter.getType()), workflowParameter.getValue()));
        }
        return spaceParamsTexts;
    }

    private String getNotificationText(Space target, NotificationType notificationType) {
        String spaceNotificationText;
        SpaceNotifications.Mode spaceNotification = this.notificationConfigManager.getSpaceNotificationsMode(target.getKey(), notificationType);
        if (spaceNotification.equals((Object)SpaceNotifications.Mode.DEFAULT)) {
            boolean isTaskNotificationEnabled = this.notificationConfigManager.isNotificationEnabled(notificationType);
            spaceNotificationText = String.format("Default (%s)", String.valueOf(isTaskNotificationEnabled));
        } else {
            spaceNotificationText = String.valueOf((Object)spaceNotification);
        }
        return spaceNotificationText;
    }

    private String getTaskAssigneeNotification(Space target) {
        return this.getNotificationText(target, NotificationType.TASK_ASSIGNMENT);
    }

    private String getTaskPageWatchersNotification(Space target) {
        return this.getNotificationText(target, NotificationType.TASK_PAGEWATCHER);
    }

    private String getApprovalAssigneeNotification(Space target) {
        return this.getNotificationText(target, NotificationType.APPROVAL_ASSIGNMENT);
    }

    private String getStateExpiredNotification(Space target) {
        return this.getNotificationText(target, NotificationType.STATE_EXPIRED);
    }

    private String getReadConfirmationNotification(Space target) {
        return this.getNotificationText(target, NotificationType.READ_CONFIRMATION);
    }
}

