/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.restv2.model;

import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonValue;

@XmlRootElement(name="restInstructions")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class RestInstructions {
    public String title;
    public String body;
    public Style style;

    public RestInstructions() {
    }

    public RestInstructions(String title, String body, Style style) {
        this.title = title;
        this.body = body;
        this.style = style;
    }

    public static enum Style {
        ERROR("error"),
        WARNING("warning"),
        SUCCESS("success"),
        INFO("info");

        public static Style DEFAULT;
        private static Map<String, Style> FORMAT_MAP;
        private final String formatted;

        private Style(String formatted) {
            this.formatted = formatted;
        }

        @JsonValue
        public String toString() {
            return this.formatted;
        }

        @JsonCreator
        public static Style fromString(String string) {
            return Optional.ofNullable(FORMAT_MAP.get(string)).orElse(DEFAULT);
        }

        static {
            DEFAULT = INFO;
            FORMAT_MAP = Stream.of(Style.values()).collect(Collectors.toMap(s -> s.formatted, Function.identity()));
        }
    }
}

