/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.model;

import com.comalatech.confluence.states.model.PageState;
import com.comalatech.confluence.workflow.ValueStore;
import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflow.model.BooleanCondition;
import com.comalatech.confluence.workflow.model.StateCondition;
import com.comalatech.confluence.workflowcontainer.model.SerializableMacro;
import java.util.List;

public class StateInitializedCondition
extends BooleanCondition {
    public StateInitializedCondition(boolean not, String value) {
        super(not, value);
    }

    @Override
    public void addMacroParameters(SerializableMacro macro) {
        macro.addParameter("initial", (Object)(!this.not ? 1 : 0));
    }

    @Override
    protected boolean evaluateBinary(ValueStore valueStore) throws WorkflowException {
        if (!this.not) {
            String state = StateCondition.getStateAccessor().getStateName(valueStore.getPage());
            List<PageState> pageStates = StateCondition.getStateAccessor().getPageStates(valueStore.getPage());
            return pageStates.stream().filter(pState -> pState.getState().equals(state)).count() == 1L;
        }
        return false;
    }

    @Override
    public String toString(ValueStore valueStore) {
        return this.not ? "Has a current state" : "Page's state is set the first time";
    }
}

