/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.listeners;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.event.events.ConfluenceEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostCreateEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostEvent;
import com.atlassian.confluence.event.events.content.page.PageCreateEvent;
import com.atlassian.confluence.event.events.content.page.PageEvent;
import com.atlassian.confluence.event.events.content.page.PageUpdateEvent;
import com.atlassian.confluence.event.events.label.LabelAddEvent;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.user.Group;
import com.atlassian.user.User;
import com.comalatech.confluence.dataextractor.ComalaPropertiesSetManager;
import com.comalatech.confluence.states.StateAccessor;
import com.comalatech.confluence.states.StateManager;
import com.comalatech.confluence.states.event.AllTasksCompleteEvent;
import com.comalatech.confluence.states.event.BlogPostStateSelectEvent;
import com.comalatech.confluence.states.event.PageStateSelectEvent;
import com.comalatech.confluence.states.event.StateTransitionEvent;
import com.comalatech.confluence.states.model.PageState;
import com.comalatech.confluence.states.model.State;
import com.comalatech.confluence.workflow.ApprovalAccessor;
import com.comalatech.confluence.workflow.ApprovalManager;
import com.comalatech.confluence.workflow.PageWorkflows;
import com.comalatech.confluence.workflow.SelectorManager;
import com.comalatech.confluence.workflow.ValueStoreManager;
import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflow.events.AllApprovalsEvent;
import com.comalatech.confluence.workflow.events.BlogPostAllApproveEvent;
import com.comalatech.confluence.workflow.events.BlogPostAllRejectEvent;
import com.comalatech.confluence.workflow.events.InternalApprovalEvent;
import com.comalatech.confluence.workflow.events.PageAllApproveEvent;
import com.comalatech.confluence.workflow.events.PageAllRejectEvent;
import com.comalatech.confluence.workflow.model.Approval;
import com.comalatech.confluence.workflow.model.ApprovalCheck;
import com.comalatech.confluence.workflow.model.ApprovalStatus;
import com.comalatech.workflow.event.approval.ApprovalApprovedEvent;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StateHandler {
    private static final Logger log = LoggerFactory.getLogger(StateHandler.class);
    private final StateManager stateManager;
    private final StateAccessor stateAccessor;
    private final ApprovalAccessor approvalAccessor;
    private final ApprovalManager approvalManager;
    private final UserAccessor userAccessor;
    private final SelectorManager selectorManager;
    private final ValueStoreManager valueStoreManager;
    private final ComalaPropertiesSetManager contentPropertyManager;
    private final EventPublisher eventPublisher;

    public StateHandler(StateManager stateManager, StateAccessor stateAccessor, ApprovalAccessor approvalAccessor, ApprovalManager approvalManager, UserAccessor userAccessor, SelectorManager selectorManager, ValueStoreManager valueStoreManager, ComalaPropertiesSetManager contentPropertyManager, EventPublisher eventPublisher) {
        this.stateManager = stateManager;
        this.stateAccessor = stateAccessor;
        this.approvalAccessor = approvalAccessor;
        this.approvalManager = approvalManager;
        this.userAccessor = userAccessor;
        this.selectorManager = selectorManager;
        this.valueStoreManager = valueStoreManager;
        this.contentPropertyManager = contentPropertyManager;
        this.eventPublisher = eventPublisher;
    }

    public void handle(PageCreateEvent event, PageWorkflows pageWorkflows) {
        this.setState(pageWorkflows);
    }

    public void handle(PageUpdateEvent event, PageWorkflows pageWorkflows) {
        PageState pageState = this.stateAccessor.getLatestState(pageWorkflows.getPage());
        if (pageState == null) {
            this.setState(pageWorkflows);
        }
    }

    public void handle(BlogPostCreateEvent event, PageWorkflows pageWorkflows) {
        this.setState(pageWorkflows);
    }

    public void handle(StateTransitionEvent event, PageWorkflows pageWorkflows) {
        PageState newState = event.getState();
        AbstractPage page = (AbstractPage)event.getContent();
        try {
            List<Approval> approvals = pageWorkflows.getApprovals(newState);
            for (Approval approval : approvals) {
                String[] requiredApprovers = null;
                if (approval.getSelector() != null && !approval.getSelector().isSelection()) {
                    requiredApprovers = this.selectorManager.getRequiredUsersNames(approval.getSelector(), pageWorkflows.getValueStore());
                } else if (approval.isRememberAssignees()) {
                    requiredApprovers = this.getPreviousValidAssignees(page, newState, approval);
                }
                if (requiredApprovers == null) continue;
                ApprovalManager.AssignApprovalMode mode = approval.isRememberAssignees() || approval.getAllowedAssignerUserCondition() != null || approval.getAllowedAssignerGroupCondition() != null ? ApprovalManager.AssignApprovalMode.BYPASS_VALIDATION : ApprovalManager.AssignApprovalMode.BYPASS_SELECTOR_CHECKS;
                for (String requiredApprover : requiredApprovers) {
                    ConfluenceUser assigneeUser = this.userAccessor.getUserByName(requiredApprover);
                    if (assigneeUser == null) continue;
                    ApprovalCheck approvalCheck = this.approvalAccessor.getLatestApprovalCheck(page, pageWorkflows.getValueStore().getPageState(), approval.getName(), 0);
                    Collection<ConfluenceUser> excludedUsers = approval.getStatus(pageWorkflows.getValueStore(), approvalCheck).getExcludedUserApprovers();
                    if (excludedUsers.contains(assigneeUser) || this.userAccessor.isDeactivated((User)assigneeUser)) continue;
                    this.approvalManager.assignApproval(page, pageWorkflows, approval.getName(), assigneeUser, null, "", mode);
                }
            }
        }
        catch (com.comalatech.workflow.WorkflowException we) {
            log.error("", (Throwable)we);
        }
        this.cleanupWorkflowProperties(page);
    }

    private String[] getPreviousValidAssignees(AbstractPage page, PageState pageState, Approval approval) {
        ArrayList<String> validPreviousAssignees = new ArrayList<String>();
        List<ApprovalCheck> approvalChecks = Arrays.asList(this.approvalAccessor.getApprovalChecks(page));
        ListIterator<ApprovalCheck> iterator = approvalChecks.listIterator(approvalChecks.size());
        while (iterator.hasPrevious()) {
            ApprovalCheck check = iterator.previous();
            if (!check.getName().equals(approval.getName())) continue;
            ArrayList<Group> possibleGroups = new ArrayList();
            ArrayList<ConfluenceUser> possibleUsers = new ArrayList();
            try {
                ApprovalStatus status = approval.getStatus(this.valueStoreManager.createValueStore(page), check);
                possibleGroups = status.getPossibleGroupApprovers();
                possibleUsers = status.getPossibleUserApprovers();
            }
            catch (WorkflowException e) {
                log.error("Error getting approval status from approval for working out valid assignees", (Throwable)e);
            }
            String[] previousApprovers = check.getRequiredApprovers();
            if (!possibleGroups.isEmpty() || !possibleUsers.isEmpty()) {
                for (String previousApprover : previousApprovers) {
                    ConfluenceUser previousApproverUser = this.userAccessor.getUserByName(previousApprover);
                    if (previousApproverUser == null || !this.userFilterMatch(previousApproverUser, possibleUsers, possibleGroups)) continue;
                    validPreviousAssignees.add(previousApprover);
                }
            } else {
                validPreviousAssignees.addAll(Arrays.asList(previousApprovers));
            }
            return validPreviousAssignees.toArray(new String[0]);
        }
        return null;
    }

    private boolean userFilterMatch(ConfluenceUser user, Collection<ConfluenceUser> filterUsers, Collection<Group> filterGroups) {
        if (filterUsers.isEmpty() && filterGroups.isEmpty()) {
            return true;
        }
        if (filterUsers.contains(user)) {
            return true;
        }
        if (!filterGroups.isEmpty()) {
            for (Group group : filterGroups) {
                if (!this.userAccessor.hasMembership(group, (User)user)) continue;
                return true;
            }
        }
        return false;
    }

    public void handle(LabelAddEvent event, PageWorkflows pageWorkflows) {
        PageState state;
        if (pageWorkflows != null && (state = this.stateAccessor.getLatestState((AbstractPage)event.getLabelled())) == null) {
            this.setState(pageWorkflows);
        }
    }

    private void cleanupWorkflowProperties(AbstractPage ceo) {
        if (TextUtils.stringSet((String)this.contentPropertyManager.getStringProperty((ContentEntityObject)ceo, "cwPublishedVersion"))) {
            this.contentPropertyManager.removeProperty((ContentEntityObject)ceo, "cwPublishedVersion");
        }
    }

    private void setState(PageWorkflows pageWorkflows) {
        if (pageWorkflows.getInitialState() == null) {
            return;
        }
        this.stateManager.setState(pageWorkflows.getValueStore(), pageWorkflows.getInitialState(), true, AuthenticatedUserThreadLocal.get(), null, null, pageWorkflows.getReadAck());
    }

    public void handle(InternalApprovalEvent event, PageWorkflows pageWorkflows) {
        if (pageWorkflows.getStatesContainer() == null) {
            return;
        }
        PageState pageState = this.stateAccessor.getLatestState(event.getAbstractPage());
        State state = pageWorkflows.getStatesContainer().getState(pageState);
        if (state == null) {
            log.warn("could not retrieve state from " + this.stateAccessor.getLatestState(event.getAbstractPage()) + " on " + event.getAbstractPage());
            return;
        }
        boolean approve = event instanceof ApprovalApprovedEvent;
        List<Approval> approvals = state.getApprovals(event.getAbstractPage());
        if (!event.isPartial() && this.approvalAccessor.hasAllRequiredChecks(event.getAbstractPage(), pageState, approvals, approve)) {
            this.publishAllApprovalsEvent((ConfluenceEvent)event, event, approve);
        }
    }

    public void handle(AllTasksCompleteEvent event, PageWorkflows pageWorkflows) {
        if (pageWorkflows.getStatesContainer() == null) {
            return;
        }
        PageState pageState = pageWorkflows.getValueStore().getPageState();
        if (pageState == null) {
            return;
        }
        State state = pageWorkflows.getStatesContainer().getState(pageState);
        if (state == null) {
            return;
        }
        if (state.getCompletedStateName() == null) {
            return;
        }
        State newState = pageWorkflows.getStatesContainer().getState(state.getCompletedStateName());
        if (newState == null) {
            return;
        }
        AbstractPage page = pageWorkflows.getPage();
        if (page instanceof Page) {
            this.eventPublisher.publish((Object)new PageStateSelectEvent(this, (Page)page, newState, null, null));
        } else {
            this.eventPublisher.publish((Object)new BlogPostStateSelectEvent(this, (BlogPost)page, newState, null, null));
        }
    }

    private void publishAllApprovalsEvent(ConfluenceEvent event, InternalApprovalEvent approvalEvent, boolean approve) {
        AllApprovalsEvent newEvent;
        if (event instanceof PageEvent) {
            newEvent = approve ? new PageAllApproveEvent(this, (Page)approvalEvent.getAbstractPage()) : new PageAllRejectEvent(this, (Page)approvalEvent.getAbstractPage());
        } else if (event instanceof BlogPostEvent) {
            newEvent = approve ? new BlogPostAllApproveEvent(this, (BlogPost)approvalEvent.getAbstractPage()) : new BlogPostAllRejectEvent(this, (BlogPost)approvalEvent.getAbstractPage());
        } else {
            throw new RuntimeException("Invalid event " + event);
        }
        this.eventPublisher.publish((Object)newEvent);
    }
}

