/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.ContentPermissionManager;
import com.atlassian.confluence.security.ContentPermission;
import com.atlassian.confluence.security.ContentPermissionSet;
import com.comalatech.confluence.workflow.WorkflowPagePermissionSetter;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.ListUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultWorkflowPagePermissionSetter
implements WorkflowPagePermissionSetter {
    private static final Logger log = LoggerFactory.getLogger(DefaultWorkflowPagePermissionSetter.class);
    private final ContentPermissionManager contentPermissionManager;

    public DefaultWorkflowPagePermissionSetter(ContentPermissionManager contentPermissionManager) {
        this.contentPermissionManager = contentPermissionManager;
    }

    @Override
    public void addContentPermission(ContentPermission permission, ContentEntityObject ceo) {
        if (log.isDebugEnabled()) {
            log.debug("Adding Content Permission: " + permission + " on page: " + ceo);
        }
        if (!this.hasContentPermission(permission, ceo)) {
            this.contentPermissionManager.addContentPermission(permission, ceo);
        }
    }

    private boolean hasContentPermission(ContentPermission contentPermission, ContentEntityObject ceo) {
        List permissionSets = this.contentPermissionManager.getContentPermissionSets(ceo, contentPermission.getType());
        if (log.isDebugEnabled()) {
            log.debug("Existing permission sets: " + permissionSets);
        }
        for (ContentPermissionSet contentPermissionSet : permissionSets) {
            if (contentPermissionSet.getOwningContent().getId() != ceo.getId() || !contentPermissionSet.contains(contentPermission)) continue;
            return true;
        }
        return false;
    }

    private void removePermission(ContentPermission permission) {
        this.contentPermissionManager.removeContentPermission(permission);
    }

    @Override
    public void removePermission(ContentPermission contentPermission, ContentEntityObject ceo) {
        if (log.isDebugEnabled()) {
            log.debug("Removing content permission: " + contentPermission + " on page: " + ceo);
        }
        ContentPermissionSet permissionSet = ceo.getContentPermissionSet(contentPermission.getType());
        if (log.isDebugEnabled()) {
            log.debug("Existing permission set: " + permissionSet);
        }
        if (permissionSet != null && permissionSet.getOwningContent().getId() == ceo.getId()) {
            for (ContentPermission permission : permissionSet.getAllExcept((Collection)Collections.EMPTY_LIST)) {
                if (permission.compareTo(contentPermission) != 0) continue;
                this.removePermission(permission);
                break;
            }
        }
    }

    @Override
    public void removePermissions(String type, ContentEntityObject ceo) {
        if (log.isDebugEnabled()) {
            log.debug("Removing content permission type: " + type + " on page: " + ceo);
        }
        ContentPermissionSet permissionSet = ceo.getContentPermissionSet(type);
        if (log.isDebugEnabled()) {
            log.debug("Existing permission set: " + permissionSet);
        }
        if (permissionSet != null && permissionSet.getOwningContent().getId() == ceo.getId()) {
            for (ContentPermission permission : permissionSet.getAllExcept((Collection)Collections.EMPTY_LIST)) {
                this.removePermission(permission);
            }
        }
    }

    @Override
    public void setContentPermissions(List<ContentPermission> newContentPermissions, ContentEntityObject ceo) {
        if (log.isDebugEnabled()) {
            log.debug("Setting content permissions: " + newContentPermissions + " on page: " + ceo);
        }
        String type = newContentPermissions.get(0).getType();
        List permissionSetsForType = this.contentPermissionManager.getContentPermissionSets(ceo, type);
        ArrayList existingPermissionsForCeo = Lists.newArrayList();
        for (ContentPermissionSet contentPermissionSetForType : permissionSetsForType) {
            if (contentPermissionSetForType.getOwningContent().getId() != ceo.getId()) continue;
            existingPermissionsForCeo.addAll(contentPermissionSetForType.getAllExcept((Collection)Collections.EMPTY_SET));
        }
        if (log.isDebugEnabled()) {
            log.debug("Existing content permisions: " + existingPermissionsForCeo + "  on page: " + ceo);
        }
        List newContentPermissionsToAdd = ListUtils.subtract(newContentPermissions, existingPermissionsForCeo);
        List existingContentPermissionsToRemove = ListUtils.subtract(existingPermissionsForCeo, newContentPermissions);
        if (log.isDebugEnabled()) {
            log.debug("Permissions to add: " + newContentPermissionsToAdd);
            log.debug("Permissions to remove: " + existingContentPermissionsToRemove);
        }
        for (ContentPermission newContentPermissionToAdd : newContentPermissionsToAdd) {
            this.contentPermissionManager.addContentPermission(newContentPermissionToAdd, ceo);
        }
        for (ContentPermission existingContentPermissionToRemove : existingContentPermissionsToRemove) {
            this.removePermission(existingContentPermissionToRemove);
        }
    }
}

