/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.states.model;

import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;

public enum StateColour {
    BLUE("#4a6785"),
    YELLOW("#FFAB00"),
    GREEN("#14892c");

    public final String value;

    private StateColour(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public static boolean isDefaultStateColour(String testColour, boolean isFinalState, boolean workflowHasFinalState) {
        if (workflowHasFinalState && isFinalState && GREEN.getValue().equals(testColour)) {
            return true;
        }
        if (workflowHasFinalState && !isFinalState && YELLOW.getValue().equals(testColour)) {
            return true;
        }
        return !workflowHasFinalState && BLUE.getValue().equals(testColour);
    }

    public static boolean isDefaultColor(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return false;
        }
        return Arrays.stream(StateColour.values()).anyMatch(action -> action.getValue().equalsIgnoreCase(value));
    }
}

