/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.documentActivity.upgrade.accessor;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.spaces.Space;
import com.comalatech.confluence.dataextractor.ComalaPropertiesSetManager;
import com.comalatech.confluence.documentActivity.upgrade.accessor.SpacePreCheckAccessor;
import com.comalatech.confluence.documentActivity.upgrade.accessor.entity.PreCheckRecord;
import java.io.IOException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpacePreCheckAccessorImpl
implements SpacePreCheckAccessor {
    private static final Logger log = LoggerFactory.getLogger(SpacePreCheckAccessorImpl.class);
    private final ComalaPropertiesSetManager comalaPropertiesSetManager;
    private static final String UPGRADE_PRE_CHECK_KEY = "com.comalatech.upgrade.pre-check";
    private final ObjectMapper objectMapper;

    public SpacePreCheckAccessorImpl(ComalaPropertiesSetManager comalaPropertiesSetManager) {
        this.comalaPropertiesSetManager = comalaPropertiesSetManager;
        this.objectMapper = new ObjectMapper();
        this.objectMapper.setSerializationInclusion(JsonSerialize.Inclusion.NON_NULL);
    }

    @Override
    public PreCheckRecord getSpacePreCheck(Space space) {
        String preCheckStr;
        PreCheckRecord preCheckRecord = null;
        if (space != null && space.getDescription() == null) {
            log.error("There is no space description object for space: " + space.getKey());
            return null;
        }
        if (space != null && space.getDescription() != null && (preCheckStr = this.comalaPropertiesSetManager.getTextProperty((ContentEntityObject)space.getDescription(), UPGRADE_PRE_CHECK_KEY)) != null) {
            preCheckRecord = this.parsePreCheckContentProperty(preCheckStr);
        }
        return preCheckRecord;
    }

    @Override
    public PreCheckRecord saveSpacePreCheck(Space space, PreCheckRecord preCheckRecord) {
        if (space != null) {
            try {
                this.comalaPropertiesSetManager.setTextProperty((ContentEntityObject)space.getDescription(), UPGRADE_PRE_CHECK_KEY, this.objectMapper.writeValueAsString((Object)preCheckRecord));
            }
            catch (IOException e) {
                log.error("Error saving pre-check key for space:" + space.getKey());
                return null;
            }
            return preCheckRecord;
        }
        return null;
    }

    private PreCheckRecord parsePreCheckContentProperty(String preCheckProperty) {
        try {
            return (PreCheckRecord)this.objectMapper.readValue(preCheckProperty, PreCheckRecord.class);
        }
        catch (IOException e) {
            log.error("Error parsing pre-check key:" + preCheckProperty);
            return null;
        }
    }
}

